AJS.toInit(function($) {
    if(AJS.Meta.get('access-mode') !== 'READ_ONLY') {
        var spaceoptionsList = jQuery("#apc-spaceoptions-list");
        if (spaceoptionsList.length) {
            jQuery.ajax(contextPath + "/rest/watch-button/1.0/watchState/" + encodeURIComponent(AJS.params.pageId))
                .success(function (data) {
                    var restMethod;
                    var i18nMethodString;
                    if (data.watchingSpace) {
                        restMethod = "DELETE";
                        i18nMethodString = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.space.removeWatch');
                    } else {
                        restMethod = "POST";
                        i18nMethodString = AJS.I18n.getText('de.communardo.confluence.plugins.apc.messages.space.addWatch');
                    }

                    var watchSpaceLink = jQuery('<li><a href="#">' + i18nMethodString + '</a></li>');
                    watchSpaceLink.click(function () {
                        // cool REST API only available from CF 6.5+
                        if (apc.isAtLeastConfluence65()) {
                            var urlSpaceWatch = "/rest/api/user/watch/space/" + encodeURIComponent(AJS.params.spaceKey);
                            jQuery.ajax({
                                url: contextPath + urlSpaceWatch,
                                type: restMethod,
                                contentType: "application/json; charset=utf-8",
                                success: function (data) {
                                    window.location.replace(contextPath + '/pages/viewpage.action?pageId=' + encodeURIComponent(AJS.params.pageId));
                                }
                            });
                        } else {
                            // use old AJAX methods to (un)watch a space
                            var urlSpaceWatchDeprecated;
                            if (restMethod === "DELETE") {
                                urlSpaceWatchDeprecated = "/users/removespacenotificationajax.action";
                            } else if (restMethod === "POST") {
                                urlSpaceWatchDeprecated = "/users/addspacenotificationajax.action";
                            }
                            jQuery.post(contextPath + urlSpaceWatchDeprecated, {
                                spaceKey: AJS.params.spaceKey,
                                atl_token: Confluence.getXsrfToken()
                            }, function (data) {
                                window.location.replace(contextPath + '/pages/viewpage.action?pageId=' + encodeURIComponent(AJS.params.pageId));
                            });
                        }
                    });
                    spaceoptionsList.append(watchSpaceLink);
                })
                .fail(function () {
                    console.log("Retrieving watch state failed:", arguments);
                });
        }
    }
});