/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.compatibility.search;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.searchfilter.ActiveUserSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.ArchivedSpacesSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.spaces.SpaceManager;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilder;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilderFactory;

public class CF7ContentSearchBuilderFactory
implements ContentSearchBuilderFactory {
    private final SpaceManager spaceManager;

    public CF7ContentSearchBuilderFactory(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @Override
    public ContentSearchBuilder createContentSearchBuilder() {
        return new ContentSearchBuilder(contentSearchBuilder -> {
            SearchFilter searchFilter = null;
            if (contentSearchBuilder.excludeArchivedSpaces) {
                searchFilter = this.addSearchFilter(searchFilter, (SearchFilter)new ArchivedSpacesSearchFilter(false, this.spaceManager));
            }
            if (contentSearchBuilder.useSiteSearchPermissionFilter) {
                searchFilter = this.addSearchFilter(searchFilter, (SearchFilter)SiteSearchPermissionsSearchFilter.getInstance());
            }
            if (contentSearchBuilder.excludeInactiveUsers) {
                searchFilter = this.addSearchFilter(searchFilter, (SearchFilter)ActiveUserSearchFilter.getInstance());
            }
            return new ContentSearch((SearchQuery)new BooleanQuery(contentSearchBuilder.mustQueries, null, null), contentSearchBuilder.sort, searchFilter, contentSearchBuilder.startOffset, contentSearchBuilder.limit);
        });
    }

    private SearchFilter addSearchFilter(SearchFilter existingSearchFilter, SearchFilter filterToAdd) {
        if (existingSearchFilter == null) {
            return filterToAdd;
        }
        existingSearchFilter.and(filterToAdd);
        return existingSearchFilter;
    }
}

