/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.util.LabelUtil;
import com.atlassian.user.User;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;

public class APCCreatePageAction
extends CreatePageAction {
    private static final long serialVersionUID = 269911696211240054L;
    private APCUtils apcUtils;
    private ContentRepresentation contentRepresentation;
    private String unexpectedError;
    private StrutsWrapper strutsWrapper;

    protected String afterAdd() {
        String result = super.afterAdd();
        LabelUtil.syncState((String)this.getLabelsString(), (LabelManager)this.getLabelManager(), (User)this.getAuthenticatedUser(), (Labelable)this.getPage());
        return result;
    }

    public void validate() {
        String pageIdParam = this.strutsWrapper.getValueForRequestParameter("fromPageId");
        this.contentRepresentation = this.apcUtils.getContentRepresentationFromRequestParameters(this.strutsWrapper.getParameterMap());
        if (this.contentRepresentation != null) {
            super.setWysiwygContent(this.apcUtils.convertWikiMarkupToWysiwyg(this.contentRepresentation, Long.parseLong(pageIdParam)));
        }
        super.validate();
    }

    public String doAdd() throws Exception {
        if (this.contentRepresentation == null) {
            this.unexpectedError = this.getText("de.communardo.confluence.plugins.apc.messages.edit.save.unexpected-error");
            return "error";
        }
        return super.doAdd();
    }

    public String getUnexpectedError() {
        return this.unexpectedError;
    }

    public void setApcUtils(APCUtils apcUtils) {
        this.apcUtils = apcUtils;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }
}

