/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.util;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.dashboard.actions.DashboardAction;
import com.atlassian.confluence.follow.FollowManager;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.CommentStatus;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.RemovePageAction;
import com.atlassian.confluence.pages.actions.ViewPageAttachmentsAction;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.pages.templates.PageTemplateManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.EditNotificationsAction;
import com.atlassian.confluence.util.AttachmentComparator;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.PeopleBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.SimpleBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.spaceia.BlogCollectorBreadcrumb;
import com.atlassian.confluence.util.breadcrumbs.spaceia.PagesCollectorBreadcrumb;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import de.communardo.confluence.plugins.apc.action.APCEditBlogPostAction;
import de.communardo.confluence.plugins.apc.action.APCEditPageAction;
import de.communardo.confluence.plugins.apc.action.APCSharePageAction;
import de.communardo.confluence.plugins.apc.action.APCViewBlogPostsAction;
import de.communardo.confluence.plugins.apc.action.APCViewInlineCommentsAction;
import de.communardo.confluence.plugins.apc.common.AccessibilityTemplate;
import de.communardo.confluence.plugins.apc.common.SkipLink;
import de.communardo.confluence.plugins.apc.comparator.PageTitleComparator;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.entity.PageEntity;
import de.communardo.confluence.plugins.apc.service.AbstractPageService;
import de.communardo.confluence.plugins.apc.service.CommentService;
import de.communardo.confluence.plugins.apc.util.APCBreadcrumb;
import de.communardo.confluence.plugins.apc.util.APCUtils;
import de.communardo.confluence.plugins.apc.util.ContentRepresentation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class APCHelper {
    private static final String CONTEXT_ATTACHMENTS = "attachments";
    private static final String CONTEXT_SEARCH = "search";
    private static final String CONTEXT_SEARCH_RESULTS = "searchresults";
    private static final String CONTEXT_SPACES = "spaces";
    private static final String CONTEXT_SPACE_EDIT = "spaceedit";
    private static final String CONTEXT_PAGE = "page";
    private static final String CONTEXT_BLOG_POST = "blogpost";
    private static final String CONTEXT_BLOG_POSTS = "blogposts";
    private static final String CONTEXT_DASHBOARD = "dashboard";
    private static final String CONTEXT_PROFILE = "profile";
    private static final String CONTEXT_EDIT_COMMENT = "editcomment";
    private static final String CONTEXT_INLINE_COMMENTS = "inlinecomments";
    private static final List<String> OPTION_SKIPLINK_CONTEXTS = Arrays.asList("page", "blogposts", "blogpost", "profile", "editcomment");
    private static final List<String> SPACE_OPTION_SKIPLINK_CONTEXTS = Arrays.asList("page", "blogposts", "blogpost", "spaceedit");
    private AbstractPageService abstractPageService;
    private APCUtils apcUtils;
    private AttachmentManager attachmentManager;
    private CommentManager commentManager;
    private CommentService commentService;
    private ContentPermissionManager contentPermissionManager;
    private FollowManager followManager;
    private PageTemplateManager pageTemplateManager;
    private UserAccessor userAccessor;
    private PageManager pageManager;
    private LikeManager likeManager;
    private StrutsWrapper strutsWrapper;

    public APCHelper(AbstractPageService abstractPageService, APCUtils apcUtils, AttachmentManager attachmentManager, CommentManager commentManager, CommentService commentService, ContentPermissionManager contentPermissionManager, FollowManager followManager, PageTemplateManager pageTemplateManager, UserAccessor userAccessor, PageManager pageManager, LikeManager likeManager, StrutsWrapperFactory strutsWrapperFactory) {
        this.abstractPageService = abstractPageService;
        this.apcUtils = apcUtils;
        this.attachmentManager = attachmentManager;
        this.commentManager = commentManager;
        this.commentService = commentService;
        this.contentPermissionManager = contentPermissionManager;
        this.followManager = followManager;
        this.pageTemplateManager = pageTemplateManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.likeManager = likeManager;
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }

    public String getAPCWikiMarkupContent(Comment comment) {
        return this.commentService.getAPCWikiMarkupContent(comment);
    }

    public ContentRepresentation getContentRepresentation(AbstractPage abstractPage) {
        return this.abstractPageService.getContentRepresentation(abstractPage);
    }

    public ContentRepresentation getNewContentRepresentation() {
        return ContentRepresentation.createWithoutLayout("");
    }

    public boolean hasContentPermissions(AbstractPage page) {
        return page != null && (page.hasContentPermissions() || !this.contentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)page).isEmpty());
    }

    public List<SkipLink> getSkipLinks(String context) {
        return this.getSkipLinks(context, new HashMap<String, Boolean>());
    }

    public List<SkipLink> getSkipLinks(String context, Map<String, Boolean> permissions) {
        ArrayList<SkipLink> skipLinks = new ArrayList<SkipLink>();
        skipLinks.add(new SkipLink("apc-skiplink-quicksearch", "de.communardo.confluence.plugins.apc.messages.skip.links.quicksearch"));
        skipLinks.add(new SkipLink("apc-skiplink-navigation", "de.communardo.confluence.plugins.apc.messages.skip.links.navigation"));
        if (StringUtils.isNotBlank((String)context) && SPACE_OPTION_SKIPLINK_CONTEXTS.contains(context)) {
            skipLinks.add(new SkipLink("apc-skiplink-spaceoptions", "de.communardo.confluence.plugins.apc.messages.skip.links.spaceoptions"));
        }
        if (StringUtils.isNotBlank((String)context) && OPTION_SKIPLINK_CONTEXTS.contains(context)) {
            skipLinks.add(new SkipLink("apc-skiplink-options", "de.communardo.confluence.plugins.apc.messages.skip.links.options"));
        }
        skipLinks.add(new SkipLink("apc-skiplink-title", "de.communardo.confluence.plugins.apc.messages.skip.links.content"));
        if (StringUtils.isNotBlank((String)context)) {
            if (context.equals(CONTEXT_PAGE) || context.equals(CONTEXT_BLOG_POST) || context.equals(CONTEXT_INLINE_COMMENTS)) {
                if (context.equals(CONTEXT_INLINE_COMMENTS)) {
                    skipLinks.add(new SkipLink("apc-skiplink-inlinecomments", "de.communardo.confluence.plugins.apc.messages.skip.links.page.inlinecomments"));
                    skipLinks.add(new SkipLink("apc-skiplink-attachmentcomments", "de.communardo.confluence.plugins.apc.messages.skip.links.page.attachmentcomments"));
                } else {
                    skipLinks.add(new SkipLink("apc-skiplink-comments", "de.communardo.confluence.plugins.apc.messages.skip.links.page.comments"));
                    if (Boolean.TRUE.equals(permissions.get("COMMENT"))) {
                        skipLinks.add(new SkipLink("apc-skiplink-comment", "de.communardo.confluence.plugins.apc.messages.skip.links.page.comment.add.new"));
                    }
                    skipLinks.add(new SkipLink("apc-skiplink-metadata", "de.communardo.confluence.plugins.apc.messages.skip.links.page.metadata"));
                }
                if (context.equals(CONTEXT_PAGE)) {
                    skipLinks.add(new SkipLink("apc-skiplink-pagestructure", "de.communardo.confluence.plugins.apc.messages.skip.links.page.structure"));
                }
            } else if (context.equals(CONTEXT_DASHBOARD)) {
                skipLinks.add(new SkipLink("apc-skiplink-dashboard-blogposts", "de.communardo.confluence.plugins.apc.messages.skip.links.dashboard.blogposts"));
                skipLinks.add(new SkipLink("apc-skiplink-dashboard-pages", "de.communardo.confluence.plugins.apc.messages.skip.links.dashboard.pages"));
            } else if (context.equals(CONTEXT_SPACES)) {
                skipLinks.add(new SkipLink("apc-skiplink-spaces-global", "de.communardo.confluence.plugins.apc.messages.skip.links.spaces.global"));
                skipLinks.add(new SkipLink("apc-skiplink-spaces-personal", "de.communardo.confluence.plugins.apc.messages.skip.links.spaces.personal"));
            } else if (context.equals(CONTEXT_SEARCH)) {
                skipLinks.add(new SkipLink("query-string", "de.communardo.confluence.plugins.apc.messages.skip.links.search"));
            } else if (context.equals(CONTEXT_SEARCH_RESULTS)) {
                skipLinks.add(new SkipLink("query-string", "de.communardo.confluence.plugins.apc.messages.skip.links.search"));
                skipLinks.add(new SkipLink("apc-skiplink-searchresults", "de.communardo.confluence.plugins.apc.messages.skip.links.search.results"));
            } else if (context.equals(CONTEXT_ATTACHMENTS)) {
                if (Boolean.TRUE.equals(permissions.get("CREATEATTACHMENT"))) {
                    skipLinks.add(new SkipLink("apc-attachment-file", "de.communardo.confluence.plugins.apc.messages.skip.links.attachment.file"));
                }
            } else if (context.equals(CONTEXT_PROFILE)) {
                skipLinks.add(new SkipLink("apc-skiplink-options", "de.communardo.confluence.plugins.apc.messages.skip.links.profile.options"));
            }
        }
        return skipLinks;
    }

    public List<Breadcrumb> getBreadcrumbs(final ConfluenceActionSupport action) {
        List<Object> breadcrumbs = new ArrayList<Breadcrumb>();
        if (action != null) {
            Page sharedPage;
            long pageId;
            final GlobalHelper helper = new GlobalHelper(action);
            breadcrumbs = helper.getBreadcrumbs();
            breadcrumbs = Lists.transform(breadcrumbs, (Function)new Function<Breadcrumb, Breadcrumb>(){

                public Breadcrumb apply(Breadcrumb breadcrumb) {
                    if (breadcrumb instanceof PagesCollectorBreadcrumb) {
                        breadcrumb = new APCBreadcrumb(action, "de.communardo.confluence.plugins.apc.messages.page.structure.title", "/apc/pages/viewpagestructure.action?spaceKey=" + HtmlUtil.urlEncode((String)helper.getSpaceKey()));
                    } else if (breadcrumb instanceof BlogCollectorBreadcrumb) {
                        breadcrumb = new APCBreadcrumb(action, "de.communardo.confluence.plugins.apc.messages.blogpost.structure", "/apc/pages/viewblogposts.action?spaceKey=" + HtmlUtil.urlEncode((String)helper.getSpaceKey()));
                    } else if (breadcrumb instanceof PeopleBreadcrumb) {
                        breadcrumb = new APCBreadcrumb(action, breadcrumb.getTitle(), null);
                    }
                    return breadcrumb;
                }
            });
            if (this.shouldAddCurrentActionToBreadcrumb(action)) {
                breadcrumbs = new ArrayList<Breadcrumb>(breadcrumbs);
                if (action.getClass() == DashboardAction.class) {
                    breadcrumbs.add((Breadcrumb)new SimpleBreadcrumb("dashboard.name", null));
                } else if (action.getClass() == EditNotificationsAction.class) {
                    breadcrumbs.add(new SimpleBreadcrumb("de.communardo.confluence.plugins.apc.messages.profile.options.manageWatches", null));
                } else if (this.useActionTitleInBreadcrumb(action)) {
                    breadcrumbs.add((Object)new APCBreadcrumb(action, action.getActionName(), null));
                } else if (action instanceof APCViewInlineCommentsAction) {
                    Breadcrumb pageBreadcrumb = this.strutsWrapper.getContentActionBreadcrumb(action, helper.getSpace(), helper.getPage(), helper.getLabel());
                    breadcrumbs.add((Object)new APCBreadcrumb(action, pageBreadcrumb.getTitle(), pageBreadcrumb.getTarget()));
                    breadcrumbs.add((Object)new APCBreadcrumb(action, action.getActionName(), null));
                } else {
                    Breadcrumb lastBreadcrumb = this.strutsWrapper.getContentActionBreadcrumb(action, helper.getSpace(), helper.getPage(), helper.getLabel());
                    breadcrumbs.add((Object)new APCBreadcrumb(action, lastBreadcrumb != null ? lastBreadcrumb.getTitle() : action.getActionName(), null));
                }
            }
            if (action instanceof APCSharePageAction && (pageId = ((APCSharePageAction)action).getPageId()) > 0L && (sharedPage = this.pageManager.getPage(pageId)) != null) {
                breadcrumbs.add(0, (Object)new APCBreadcrumb(action, sharedPage.getTitle(), null));
            }
        }
        return breadcrumbs;
    }

    private boolean shouldAddCurrentActionToBreadcrumb(ConfluenceActionSupport action) {
        return !(action instanceof APCViewBlogPostsAction) || !((APCViewBlogPostsAction)action).isDateView();
    }

    private boolean useActionTitleInBreadcrumb(ConfluenceActionSupport action) {
        return action instanceof ViewPageAttachmentsAction || action instanceof RemovePageAction || action instanceof APCEditPageAction || action instanceof APCEditBlogPostAction;
    }

    public String getCurrentPostingDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date());
    }

    public List<Attachment> getLatestVersionsOfAttachments(ContentEntityObject contentEntityObject) {
        List latestVersionsOfAttachments = this.attachmentManager.getLatestVersionsOfAttachments(contentEntityObject);
        if (latestVersionsOfAttachments != null && latestVersionsOfAttachments.size() > 1) {
            Collections.sort(latestVersionsOfAttachments, new AttachmentComparator("name", false));
        }
        return latestVersionsOfAttachments;
    }

    public String getPreferredUserLanguage() {
        String userLocale;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && StringUtils.isNotBlank((String)(userLocale = this.userAccessor.getPropertySet(user).getString("confluence.user.locale")))) {
            return new Locale(userLocale.split("_")[0]).getLanguage();
        }
        return null;
    }

    public List<AccessibilityTemplate> getAccessibilityTemplates() {
        ArrayList<AccessibilityTemplate> accessibilityTemplates = new ArrayList<AccessibilityTemplate>();
        if (this.pageTemplateManager != null) {
            for (Object pageTemplateObj : this.pageTemplateManager.getGlobalPageTemplates()) {
                MacroDefinition accessibilityTemplateMacro;
                PageTemplate pageTemplate;
                if (!(pageTemplateObj instanceof PageTemplate) || !(pageTemplate = (PageTemplate)pageTemplateObj).isLatestVersion() || (accessibilityTemplateMacro = this.apcUtils.getSpecificMacroDef(new PageContext(), pageTemplate.getContent(), "accessibilitytemplate")) == null) continue;
                accessibilityTemplates.add(new AccessibilityTemplate(pageTemplate.getId(), pageTemplate.getTitle(), accessibilityTemplateMacro.getBodyText(), pageTemplate.getLabels()));
            }
        }
        return accessibilityTemplates;
    }

    public Comment getCommentById(String id) {
        return this.commentManager.getComment(Long.parseLong(id));
    }

    public List<Page> sortPageList(List<Page> pageList) {
        ArrayList<Page> tempList = new ArrayList<Page>(pageList);
        Collections.sort(tempList, new PageTitleComparator());
        return tempList;
    }

    public List<Page> getPermittedChildren(Page page) {
        return this.contentPermissionManager.getPermittedChildren(page, (User)AuthenticatedUserThreadLocal.get());
    }

    public List<PageEntity> getPermittedChildren(PageEntity pageEntity) {
        return pageEntity.getChildren();
    }

    public boolean hasPermittedChildren(Page page) {
        return !this.getPermittedChildren(page).isEmpty();
    }

    public boolean isCF58OrNewer() {
        return this.apcUtils.isCF58OrNewer();
    }

    public List<Page> getTopLevelPages(AbstractPage abstractPage) {
        ListBuilder pagesBuilder = this.pageManager.getTopLevelPagesBuilder(abstractPage.getSpace());
        return pagesBuilder.getRange(0, pagesBuilder.getAvailableSize());
    }

    public List<PageEntity> getPageTreeReduced(Page currentPage) {
        List pageAncestors = currentPage.getAncestors();
        pageAncestors.add(currentPage);
        List<Page> topLevelPages = this.getTopLevelPages((AbstractPage)currentPage);
        ArrayList<PageEntity> pageTree = new ArrayList<PageEntity>();
        Page spaceHomePage = currentPage.getSpace().getHomePage();
        for (Page toplevelPage : topLevelPages) {
            PageEntity topLevelPageEntity = this.createTopLevelPageEntity(currentPage, spaceHomePage, toplevelPage);
            pageTree.add(topLevelPageEntity);
            if (!pageAncestors.contains(toplevelPage)) continue;
            topLevelPageEntity.setChildren(this.getPageEntityChildrenReduced(pageAncestors, toplevelPage, topLevelPageEntity, currentPage));
        }
        return pageTree;
    }

    private PageEntity createTopLevelPageEntity(Page currentPage, Page spaceHomePage, Page toplevelPage) {
        PageEntity topLevelPageEntity = new PageEntity(toplevelPage.getTitle(), toplevelPage.getIdAsString(), toplevelPage.getUrlPath());
        topLevelPageEntity.setHomePage(spaceHomePage == toplevelPage);
        topLevelPageEntity.setCurrentPage(currentPage == toplevelPage);
        return topLevelPageEntity;
    }

    private List<PageEntity> getPageEntityChildrenReduced(List<Page> pageAncestors, Page page, PageEntity pageEntity, Page currentPage) {
        ArrayList<PageEntity> childPageEntities = new ArrayList<PageEntity>();
        for (Page childPage : this.getPermittedChildren(page)) {
            if (!pageAncestors.contains(childPage)) continue;
            PageEntity childPageEntity = new PageEntity(childPage.getTitle(), childPage.getIdAsString(), childPage.getUrlPath());
            if (childPage == currentPage) {
                childPageEntity.setCurrentPage(true);
                for (Page sibling : page.getChildren()) {
                    if (sibling == currentPage) continue;
                    PageEntity siblingEntity = new PageEntity(sibling.getTitle(), sibling.getIdAsString(), sibling.getUrlPath());
                    pageEntity.addChild(siblingEntity);
                }
            }
            childPageEntity.setChildren(this.getPageEntityChildrenReduced(pageAncestors, childPage, childPageEntity, currentPage));
            childPageEntities.add(childPageEntity);
            return childPageEntities;
        }
        return null;
    }

    @Nonnull
    public List<PageEntity> getPageTree(Page currentPage) {
        ArrayList<PageEntity> pageEntities = new ArrayList<PageEntity>();
        List<Page> topLevelPages = this.getTopLevelPages((AbstractPage)currentPage);
        Page spaceHomePage = currentPage.getSpace().getHomePage();
        for (Page toplevelPage : topLevelPages) {
            PageEntity topLevelPageEntity = this.createTopLevelPageEntity(currentPage, spaceHomePage, toplevelPage);
            topLevelPageEntity.setChildren(this.getPageEntityChildren(toplevelPage, currentPage));
            pageEntities.add(topLevelPageEntity);
        }
        return pageEntities;
    }

    private List<PageEntity> getPageEntityChildren(Page page, Page currentPage) {
        ArrayList<PageEntity> childPageEntities = new ArrayList<PageEntity>();
        for (Page childPage : this.getPermittedChildren(page)) {
            PageEntity childPageEntity = new PageEntity(childPage.getTitle(), childPage.getIdAsString(), childPage.getUrlPath());
            if (childPage == currentPage) {
                childPageEntity.setCurrentPage(true);
            }
            childPageEntity.setChildren(this.getPageEntityChildren(childPage, currentPage));
            childPageEntities.add(childPageEntity);
        }
        return childPageEntities;
    }

    public User getUserByKey(String userkey) {
        return this.userAccessor.getUserByKey(new UserKey(userkey));
    }

    public Date getDateByMillis(long date) {
        return new Date(date);
    }

    public boolean hasUserLikedComment(Comment comment, User user) {
        return user != null && comment != null && this.likeManager.hasLike((ContentEntityObject)comment, user);
    }

    public List<Like> getLikes(ContentEntityObject ceo) {
        return this.likeManager.getLikes(ceo);
    }

    public boolean isUserFollowing(User follower, User followee) {
        return this.followManager.isUserFollowing(follower, followee);
    }

    public boolean isInlineCommentById(String commentId) {
        Long id;
        Comment comment;
        if (!StringUtils.isBlank((String)commentId) && (comment = this.commentManager.getComment((id = Long.valueOf(Long.parseLong(commentId))).longValue())) != null) {
            return comment.isInlineComment() || comment.getContainer() instanceof Attachment;
        }
        return false;
    }

    public boolean hasAttachmentResolvedComments(Attachment attachment) {
        if (attachment != null) {
            for (Comment comment : attachment.getComments()) {
                if (comment.getParent() != null || !comment.getStatus().isResolved() && !comment.getStatus().isDangling()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAttachmentOpenComments(Attachment attachment) {
        if (attachment != null) {
            for (Comment comment : attachment.getComments()) {
                CommentStatus commentStatus = comment.getStatus();
                if ((comment.getParent() != null || !commentStatus.isOpen()) && !commentStatus.isReopened()) continue;
                return true;
            }
        }
        return false;
    }
}

