/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action.favourite;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.service.ValidationError;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.service.LabelsService;
import com.atlassian.confluence.labels.service.RemoveLabelCommand;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.userstatus.FavouriteManager;
import com.atlassian.user.User;
import org.apache.commons.lang.StringUtils;

@ReadOnlyAccessBlocked
public class APCRemoveFavouriteAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private LabelsService labelsService;
    private FavouriteManager favouriteManager;
    private SpaceManager spaceManager;
    private String contentId;
    private String contentType;

    public String execute() throws Exception {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null && StringUtils.isNotBlank((String)this.contentType) && StringUtils.isNotBlank((String)this.contentId)) {
            if (this.contentType.equals("space")) {
                this.favouriteManager.removeSpaceFromFavourites((User)user, this.spaceManager.getSpace(this.contentId));
            } else {
                Label favouriteLabel = new Label("favourite", Namespace.PERSONAL, user);
                if (!this.runCommand(this.labelsService.newRemoveLabelCommand(favouriteLabel, (User)user, Long.parseLong(this.contentId)))) {
                    return "error";
                }
            }
        }
        return "success";
    }

    private boolean runCommand(RemoveLabelCommand command) {
        if (!command.isValid()) {
            for (ValidationError error : command.getValidationErrors()) {
                this.addActionError(error.getMessageKey(), error.getArgs());
            }
            return false;
        }
        command.execute();
        return true;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLabelsService(LabelsService labelsService) {
        this.labelsService = labelsService;
    }

    public void setFavouriteManager(FavouriteManager favouriteManager) {
        this.favouriteManager = favouriteManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

