/*
 * Decompiled with CFR 0.152.
 */
package de.communardo.confluence.plugins.apc.action;

import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.PredefinedSearchBuilder;
import com.atlassian.confluence.search.service.SearchQueryParameters;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.sort.FullnameSort;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.confluence.user.actions.PeopleDirectoryAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapper;
import de.communardo.confluence.plugins.apc.compatibility.StrutsWrapperFactory;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilder;
import de.communardo.confluence.plugins.apc.compatibility.search.ContentSearchBuilderFactory;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APCPeopleDirectoryAction
extends PeopleDirectoryAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(APCPeopleDirectoryAction.class);
    private SearchManager searchManagerApc;
    private AnyTypeDao anyTypeDao;
    private PredefinedSearchBuilder predefinedSearchBuilder;
    private Set<String> searchResults = Sets.newLinkedHashSet();
    private UserManager userManager;
    private StrutsWrapper strutsWrapper;
    private ContentSearchBuilderFactory contentSearchBuilderFactory;

    public String doBrowse() {
        if (!this.isUPPEnabled()) {
            return super.doSearch();
        }
        this.setQueryString("");
        this.search();
        return "success";
    }

    public String doSearch() {
        if (!this.isUPPEnabled()) {
            return super.doSearch();
        }
        this.strutsWrapper.addToHttpSession("confluence.user.dir.search.string", this.getQueryString());
        this.search();
        return "success";
    }

    private void search() {
        ISearch search = this.buildSearch();
        SearchResults searchResults = null;
        try {
            searchResults = this.searchManagerApc.search(search);
        }
        catch (InvalidSearchException e) {
            LOGGER.error("Error while searching for user profiles.");
        }
        List resultObjects = this.searchManagerApc.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION);
        super.getPaginationSupport().setStartIndex(super.getStartIndex());
        super.getPaginationSupport().setTotal(searchResults.getUnfilteredResultsCount());
        super.getPaginationSupport().setItems(resultObjects);
        this.createProfiles(searchResults.getAll());
    }

    private void createProfiles(List<SearchResult> results) {
        for (SearchResult result : results) {
            Object pi = this.anyTypeDao.findByHandle(result.getHandle());
            if (pi instanceof PersonalInformation) {
                UserProfile userProfile;
                ConfluenceUser user = ((PersonalInformation)pi).getUser();
                boolean userFound = false;
                if (user != null && this.userAccessor.getExistingUserByKey(user.getKey()) != null && (userProfile = this.userManager.getUserProfile(user.getName())) != null) {
                    this.searchResults.add(userProfile.getUsername());
                    userFound = true;
                }
                if (userFound) continue;
                LOGGER.debug("Search result '{}' represents user which does not exist in the system anymore. Will be ignored.", (Object)result.getDisplayTitle());
                continue;
            }
            LOGGER.debug("Search result '{}' can not be related to a PersonalInformation object and will be ignored.", (Object)result.getDisplayTitle());
        }
    }

    private ISearch buildSearch() {
        String queryString = this.getQueryString().replaceAll(",", " AND ");
        SearchQueryParameters params = new SearchQueryParameters(queryString);
        params.setContentType(ContentTypeEnum.PERSONAL_INFORMATION);
        ISearch dummySearch = this.predefinedSearchBuilder.buildSiteSearch(params, super.getStartIndex(), Integer.MAX_VALUE);
        ContentSearchBuilder contentSearchBuilder = this.contentSearchBuilderFactory.createContentSearchBuilder();
        return contentSearchBuilder.addMustQuery(dummySearch.getQuery()).setUseSiteSearchPermissionFilter(true).setExcludeInactiveUsers(true).setStartOffset(0).setLimit(50).setSort((SearchSort)FullnameSort.ASCENDING).createSiteSearch();
    }

    private boolean isUPPEnabled() {
        return this.pluginAccessor.isPluginEnabled("de.communardo.confluence.plugins.userprofile");
    }

    public List<String> getSearchResults() {
        if (this.isUPPEnabled()) {
            return Lists.newArrayList(this.searchResults);
        }
        return super.getSearchResults();
    }

    @HtmlSafe
    public String getPaginationContextUrl() {
        String contextUrl;
        if (StringUtils.isBlank((CharSequence)this.getQueryString())) {
            contextUrl = "browsepeople.action?";
        } else {
            contextUrl = "dopeopledirectorysearch.action?";
            contextUrl = contextUrl + "queryString=" + this.getQueryString();
            contextUrl = contextUrl + "&search=" + this.getText("search.name");
            contextUrl = contextUrl + "&showOnlyPersonal=false";
            contextUrl = contextUrl + "&";
        }
        return contextUrl;
    }

    public void setSearchManagerApc(SearchManager searchManager) {
        this.searchManagerApc = searchManager;
    }

    public void setAnyTypeDao(AnyTypeDao anyTypeDao) {
        this.anyTypeDao = anyTypeDao;
    }

    public void setUppUserManager(UserManager userMan) {
        this.userManager = userMan;
    }

    public void setPredefinedSearchBuilder(PredefinedSearchBuilder predefinedSearchBuilder) {
        this.predefinedSearchBuilder = predefinedSearchBuilder;
    }

    public void setStrutsWrapperFactory(StrutsWrapperFactory strutsWrapperFactory) {
        this.strutsWrapper = strutsWrapperFactory.getStrutsWrapper();
    }

    public void setContentSearchBuilderFactory(ContentSearchBuilderFactory contentSearchBuilderFactory) {
        this.contentSearchBuilderFactory = contentSearchBuilderFactory;
    }
}

