/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.shared.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.FormatConverter;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.velocity.htmlsafe.HtmlFragment;
import de.actonic.confluence.ctipe.shared.encoder.URIEncoder;
import java.util.Base64;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class IteTableMacro
implements Macro {
    private final FormatConverter defaultFormatConverter = (FormatConverter)ContainerManager.getComponent((String)"formatConverter");

    public String execute(Map<String, String> parameters, String renderedMacroBody, ConversionContext conversionContext) throws MacroExecutionException {
        MacroDefinition macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition");
        String rawMacroBody = macroDefinition.getStorageBodyText();
        String editorMacroBody = this.defaultFormatConverter.convertToEditorFormat(rawMacroBody, (RenderContext)new PageContext());
        if (StringUtils.isEmpty((CharSequence)rawMacroBody) && conversionContext.getOutputType().equals("preview")) {
            return VelocityUtils.getRenderedTemplate((String)"/templates/ite-table-macro-preview.vm", (Map)MacroUtils.defaultVelocityContext());
        }
        String hash = DigestUtils.sha512Hex((String)rawMacroBody);
        String macroId = macroDefinition.getMacroIdentifier().orElse(MacroId.fromString((String)hash)).getId();
        Map context = MacroUtils.defaultVelocityContext();
        String renderedMacroBodyURI = URIEncoder.encodeURIComponent(renderedMacroBody);
        String editorMacroBodyURI = URIEncoder.encodeURIComponent(editorMacroBody);
        String macroRenderedBodyBase64 = Base64.getEncoder().encodeToString(renderedMacroBodyURI.getBytes());
        String macroEditorBodyBase64 = Base64.getEncoder().encodeToString(editorMacroBodyURI.getBytes());
        context.put("macroRenderedBody", new HtmlFragment((Object)renderedMacroBody));
        context.put("macroRenderedBodyBase64", macroRenderedBodyBase64);
        context.put("macroEditorBody", new HtmlFragment((Object)editorMacroBody));
        context.put("macroEditorBodyBase64", macroEditorBodyBase64);
        context.put("macroId", macroId);
        boolean enableInlineEdit = Boolean.valueOf(parameters.getOrDefault("enableInlineEdit", "true"));
        boolean enableFiltering = Boolean.valueOf(parameters.getOrDefault("enableFiltering", "true"));
        boolean enableSorting = Boolean.valueOf(parameters.getOrDefault("enableSorting", "true"));
        boolean enableExport = Boolean.valueOf(parameters.getOrDefault("enableExport", "true"));
        boolean enableDragAndDrop = Boolean.valueOf(parameters.getOrDefault("enableDragAndDrop", "true"));
        boolean enableCompactTheme = Boolean.valueOf(parameters.getOrDefault("enableCompactTheme", "false"));
        boolean enableRowNumbers = Boolean.valueOf(parameters.getOrDefault("enableRowNumbers", "false"));
        boolean enableAutoStretch = Boolean.valueOf(parameters.getOrDefault("enableAutoStretch", "false"));
        int tableHeight = Integer.valueOf(parameters.getOrDefault("tableHeight", "0"));
        if (tableHeight < 0) {
            tableHeight = 0;
        }
        if (tableHeight > 0 && tableHeight < 30) {
            tableHeight = 30;
        }
        context.put("enableInlineEdit", enableInlineEdit);
        context.put("enableFiltering", enableFiltering);
        context.put("enableSorting", enableSorting);
        context.put("enableExport", enableExport);
        context.put("enableDragAndDrop", enableDragAndDrop);
        context.put("enableCompactTheme", enableCompactTheme);
        context.put("enableRowNumbers", enableRowNumbers);
        context.put("enableAutoStretch", enableAutoStretch);
        context.put("tableHeight", tableHeight);
        return VelocityUtils.getRenderedTemplate((String)"/templates/ite-table-macro.vm", (Map)context);
    }

    private String convertTextToBase64(String text) {
        return Base64.getEncoder().encodeToString(text.getBytes());
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }
}

