/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.shared.component;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActonicLicenseService {
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginAccessor pluginAccessor;
    private final String hostBaseUrl;

    @Autowired
    public ActonicLicenseService(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ApplicationProperties applicationProperties) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginAccessor = pluginAccessor;
        this.hostBaseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
    }

    public boolean isLicenseValid() {
        if (!this.pluginAccessor.isPluginModuleEnabled("de.actonic.inline-table-editing:invalidate-license-check")) {
            return false;
        }
        if (this.pluginLicenseManager.getLicense().isDefined() && ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid()) {
            return true;
        }
        return this.isBaseUrlBelongsToActonic(this.hostBaseUrl);
    }

    public boolean isBaseUrlBelongsToActonic(String baseUrl) {
        return baseUrl != null && (baseUrl.startsWith("http://localhost") || baseUrl.startsWith("https://") && baseUrl.endsWith(".actonic.io"));
    }
}

