/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.conf8.rest;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import de.actonic.confluence.ctipe.shared.component.ActonicLicenseService;
import de.actonic.confluence.ctipe.shared.component.NewTableService;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/new-ite")
public class NewTableRest {
    private static final Logger log = LoggerFactory.getLogger(NewTableRest.class);
    private final NewTableService newTableService;
    private final ActonicLicenseService actonicLicenseService;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;

    @Autowired
    public NewTableRest(NewTableService newTableService, ActonicLicenseService actonicLicenseService, PageManager pageManager, PermissionManager permissionManager) {
        this.newTableService = newTableService;
        this.actonicLicenseService = actonicLicenseService;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    @POST
    @Path(value="/save")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response saveTable(@FormParam(value="pageId") Long pageId, @FormParam(value="macroId") String macroId, @FormParam(value="table") String table) {
        try {
            if (this.actonicLicenseService.isLicenseValid()) {
                String newMacroId = this.newTableService.saveNewTable(pageId, macroId, table);
                return Response.ok().entity((Object)newMacroId).build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (XhtmlException e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/edit-permissions/{id}")
    @Produces(value={"application/json"})
    public Response checkLicense(@PathParam(value="id") Long pageId) throws Exception {
        if (this.actonicLicenseService.isLicenseValid()) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (confluenceUser == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            Page page = this.pageManager.getPage(pageId.longValue());
            if (page == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            final boolean editPermissions = this.permissionManager.hasPermissionNoExemptions((User)confluenceUser, Permission.EDIT, (Object)page);
            return Response.ok((Object)new HashMap<String, Boolean>(){
                {
                    this.put("hasEditPermission", editPermissions);
                }
            }).build();
        }
        return Response.ok((Object)new HashMap<String, Boolean>(){
            {
                this.put("hasEditPermission", false);
            }
        }).build();
    }

    @Path(value="/license")
    @GET
    @Produces(value={"application/json"})
    public Response checkLicense() throws Exception {
        return Response.ok((Object)new HashMap<String, Boolean>(){
            {
                this.put("licenseValid", NewTableRest.this.actonicLicenseService.isLicenseValid());
            }
        }).build();
    }
}

