/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.conf8.component;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitializerListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(InitializerListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final PluginController pluginController;
    private final List<String> modulesToEnable = Arrays.asList("tie-actions-admin-c8", "ite-actions-space-c8", "ite-actions-users-c8");

    @Autowired
    public InitializerListener(EventPublisher eventPublisher, PluginController pluginController) {
        this.eventPublisher = eventPublisher;
        this.pluginController = pluginController;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (event.getPlugin() != null && StringUtils.equalsIgnoreCase((CharSequence)"de.actonic.inline-table-editing", (CharSequence)event.getPlugin().getKey())) {
            Plugin plugin = event.getPlugin();
            this.modulesToEnable.forEach(module -> {
                ModuleDescriptor actionModuleDesc = plugin.getModuleDescriptor(module);
                if (actionModuleDesc != null && !actionModuleDesc.isEnabled()) {
                    this.pluginController.enablePluginModule(actionModuleDesc.getCompleteKey());
                }
            });
        }
    }
}

