/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.shared.component;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.ctipe.shared.model.RestrictionEntityType;
import de.actonic.confluence.ctipe.shared.model.RestrictionModel;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RestrictionService {
    private static final Logger log = LoggerFactory.getLogger(RestrictionService.class);
    private final String RESTRICTIONS_CACHE_NAME = "inline-table-editing-restrictions-cache";
    private static final String RESTRICTION_KEY = "ite-restriction-key";
    private static final String ALPHABET = "abcdefghigklmnopqrstuvwxyz";
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    @ComponentImport
    private final ContentEntityManager contentEntityManager;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final Cache<String, String> restrictionsCache;

    @Autowired
    public RestrictionService(ContentPropertyManager contentPropertyManager, @ComponentImport CacheManager cacheManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, SpaceManager spaceManager, GroupManager groupManager, UserAccessor userAccessor, PageManager pageManager, PermissionManager permissionManager) {
        this.contentPropertyManager = contentPropertyManager;
        this.contentEntityManager = contentEntityManager;
        this.spaceManager = spaceManager;
        this.groupManager = groupManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.restrictionsCache = cacheManager.getCache("inline-table-editing-restrictions-cache");
    }

    public List<RestrictionModel> getRestrictions(Long pageId, boolean convertRestrictions) throws Exception {
        ContentEntityObject ceo = this.contentEntityManager.getById(pageId.longValue());
        return this.get(ceo, convertRestrictions);
    }

    public List<RestrictionModel> getRestrictions(String spaceKey, boolean convertRestrictions) throws Exception {
        Space space = this.spaceManager.getSpace(spaceKey);
        return this.get((ContentEntityObject)space.getDescription(), convertRestrictions);
    }

    private List<RestrictionModel> get(ContentEntityObject ceo, boolean convertRestrictions) throws Exception {
        if (ceo == null) {
            throw new Exception("ite.restrictions.exceptions.notFoundContentById");
        }
        String contentPropertyString = this.contentPropertyManager.getStringProperty(ceo, RESTRICTION_KEY);
        List<Object> results = StringUtils.isNotBlank((CharSequence)contentPropertyString) ? this.getRestrictionsFromString(contentPropertyString) : new ArrayList();
        ArrayList<RestrictionModel> converted = new ArrayList<RestrictionModel>();
        Iterator<Object> iterator = results.iterator();
        while (iterator.hasNext()) {
            RestrictionModel res;
            RestrictionModel restrictionModel = res = (RestrictionModel)iterator.next();
            restrictionModel.setUsers(convertRestrictions ? this.convertUserKeysToUserNames(res.getUsers()) : res.getUsers());
            converted.add(restrictionModel);
        }
        return converted;
    }

    private void saveRestriction(Long pageId, List<RestrictionModel> restrictionModels) throws Exception {
        ContentEntityObject ceo = this.contentEntityManager.getById(pageId.longValue());
        this.save(ceo, restrictionModels);
    }

    private void saveRestriction(String spaceKey, List<RestrictionModel> restrictionModels) throws Exception {
        Space space = this.spaceManager.getSpace(spaceKey);
        this.save((ContentEntityObject)space.getDescription(), restrictionModels);
    }

    private void save(ContentEntityObject ceo, List<RestrictionModel> restrictionModels) throws Exception {
        String json = new Gson().toJson(restrictionModels);
        if (json.length() > 4096) {
            throw new Exception("ite.restrictions.exceptions.maxPropertyLength");
        }
        this.contentPropertyManager.setStringProperty(ceo, RESTRICTION_KEY, json);
    }

    private String convertUserNamesToUserKeys(String userNames) {
        if (StringUtils.isBlank((CharSequence)userNames)) {
            return userNames;
        }
        String[] userNameArr = userNames.split(",");
        ArrayList<String> userKeyArr = new ArrayList<String>();
        for (String name : userNameArr) {
            ConfluenceUser user = this.userAccessor.getUserByName(name);
            if (user == null) continue;
            userKeyArr.add(user.getKey().getStringValue());
        }
        return String.join((CharSequence)",", userKeyArr);
    }

    private String convertUserKeysToUserNames(String userKeys) {
        if (StringUtils.isBlank((CharSequence)userKeys)) {
            return userKeys;
        }
        String[] userKeyArr = userKeys.split(",");
        ArrayList<Object> userNameArr = new ArrayList<Object>();
        for (String key : userKeyArr) {
            ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(key));
            if (user != null) {
                userNameArr.add(user.getName());
                continue;
            }
            userNameArr.add("Undefined user [" + key + "]");
        }
        return String.join((CharSequence)",", userNameArr);
    }

    public RestrictionModel addRestriction(Long pageId, String groupString, String userString) throws Exception {
        this.restrictionsCache.removeAll();
        if (StringUtils.isBlank((CharSequence)groupString) && StringUtils.isBlank((CharSequence)userString)) {
            throw new Exception("ite.restrictions.exceptions.needUserOrGroup");
        }
        List<RestrictionModel> restrictionModels = this.getRestrictions(pageId, false);
        if (this.isUserHasRestriction(restrictionModels, userString) || this.isGroupHasRestriction(restrictionModels, groupString)) {
            throw new Exception("ite.restrictions.exceptions.twiceUsedRestriction");
        }
        RestrictionModel restriction = RestrictionModel.builder().id(this.createHashCode()).entityType(RestrictionEntityType.PAGE.getType()).groups(groupString).users(this.convertUserNamesToUserKeys(userString)).build();
        restrictionModels.add(restriction);
        this.saveRestriction(pageId, restrictionModels);
        restriction.setUsers(userString);
        return restriction;
    }

    public RestrictionModel addRestriction(String spaceKey, String groupString, String userString) throws Exception {
        this.restrictionsCache.removeAll();
        if (StringUtils.isBlank((CharSequence)groupString) && StringUtils.isBlank((CharSequence)userString)) {
            throw new Exception("ite.restrictions.exceptions.needUserOrGroup");
        }
        if (StringUtils.isBlank((CharSequence)spaceKey)) {
            throw new Exception("ite.restrictions.exceptions.needSpaceKey");
        }
        List<RestrictionModel> restrictionModels = this.getRestrictions(spaceKey, false);
        if (this.isUserHasRestriction(restrictionModels, userString) || this.isGroupHasRestriction(restrictionModels, groupString)) {
            throw new Exception("ite.restrictions.exceptions.twiceUsedRestriction");
        }
        RestrictionModel restriction = RestrictionModel.builder().id(this.createHashCode()).entityType(RestrictionEntityType.SPACE.getType()).groups(groupString).users(this.convertUserNamesToUserKeys(userString)).build();
        restrictionModels.add(restriction);
        this.saveRestriction(spaceKey, restrictionModels);
        restriction.setUsers(userString);
        return restriction;
    }

    public void removeRestriction(Long pageId, Integer restrictionId) throws Exception {
        this.restrictionsCache.removeAll();
        List<RestrictionModel> restrictionModels = this.getRestrictions(pageId, false);
        restrictionModels = restrictionModels.stream().filter(model -> !model.getId().equals(restrictionId)).collect(Collectors.toList());
        this.saveRestriction(pageId, restrictionModels);
    }

    public void removeRestriction(String spaceKey, Integer restrictionId) throws Exception {
        this.restrictionsCache.removeAll();
        List<RestrictionModel> restrictionModels = this.getRestrictions(spaceKey, false);
        restrictionModels = restrictionModels.stream().filter(model -> !model.getId().equals(restrictionId)).collect(Collectors.toList());
        this.saveRestriction(spaceKey, restrictionModels);
    }

    public void removeAll(Long pageId) throws Exception {
        this.restrictionsCache.removeAll();
        this.saveRestriction(pageId, new ArrayList<RestrictionModel>());
    }

    public void removeAll(String spaceKey) throws Exception {
        this.restrictionsCache.removeAll();
        this.saveRestriction(spaceKey, new ArrayList<RestrictionModel>());
    }

    public void updateRestriction(Long pageId, Integer restrictionId, String groupString, String userString) throws Exception {
        this.restrictionsCache.removeAll();
        List<RestrictionModel> restrictionModels = this.getRestrictions(pageId, false);
        Integer restrictionIndex = this.getRestrictionIndex(restrictionModels, restrictionId);
        if (restrictionIndex == -1) {
            throw new Exception("ite.restrictions.exceptions.notFoundRestrictionById");
        }
        if (StringUtils.isBlank((CharSequence)groupString) && StringUtils.isBlank((CharSequence)userString)) {
            throw new Exception("ite.restrictions.exceptions.needUserOrGroup");
        }
        if (this.isUserHasRestriction(restrictionModels, userString) || this.isGroupHasRestriction(restrictionModels, groupString)) {
            throw new Exception("ite.restrictions.exceptions.twiceUsedRestriction");
        }
        RestrictionModel restriction = RestrictionModel.builder().id(restrictionId).entityType(RestrictionEntityType.PAGE.getType()).groups(groupString).users(this.convertUserNamesToUserKeys(userString)).build();
        restrictionModels.set(restrictionIndex, restriction);
        this.saveRestriction(pageId, restrictionModels);
    }

    public void updateRestriction(String spaceKey, Integer restrictionId, String groupString, String userString) throws Exception {
        this.restrictionsCache.removeAll();
        List<RestrictionModel> restrictionModels = this.getRestrictions(spaceKey, false);
        Integer restrictionIndex = this.getRestrictionIndex(restrictionModels, restrictionId);
        if (restrictionIndex == -1) {
            throw new Exception("ite.restrictions.exceptions.notFoundRestrictionById");
        }
        if (StringUtils.isBlank((CharSequence)groupString) && StringUtils.isBlank((CharSequence)userString)) {
            throw new Exception("ite.restrictions.exceptions.needUserOrGroup");
        }
        if (this.isUserHasRestriction(restrictionModels, userString) || this.isGroupHasRestriction(restrictionModels, groupString)) {
            throw new Exception("ite.restrictions.exceptions.twiceUsedRestriction");
        }
        RestrictionModel restriction = RestrictionModel.builder().id(restrictionId).entityType(RestrictionEntityType.SPACE.getType()).groups(groupString).users(this.convertUserNamesToUserKeys(userString)).build();
        restrictionModels.set(restrictionIndex, restriction);
        this.saveRestriction(spaceKey, restrictionModels);
    }

    private int getRestrictionIndex(List<RestrictionModel> restrictionModels, Integer restrictionId) {
        RestrictionModel restriction = restrictionModels.stream().filter(model -> model.getId().equals(restrictionId)).findFirst().orElse(null);
        return restriction != null ? restrictionModels.indexOf(restriction) : -1;
    }

    private List<RestrictionModel> getRestrictionsFromString(String restrictionString) {
        Type type = new TypeToken<List<RestrictionModel>>(this){}.getType();
        return (List)new Gson().fromJson(restrictionString, type);
    }

    private int createHashCode() {
        String resultString = System.currentTimeMillis() + "_";
        Integer cicle = new Random(10L).nextInt();
        for (int i = 0; i < cicle; ++i) {
            resultString = resultString + ALPHABET.charAt(new Random(26L).nextInt());
        }
        return resultString.hashCode();
    }

    public boolean isUserAllowedToUseInlineEditingForPage(ConfluenceUser confluenceUser, long pageId) throws Exception {
        if (confluenceUser == null || pageId == 0L) {
            return false;
        }
        String cacheKey = confluenceUser.getKey().getStringValue() + ":" + pageId;
        if (this.restrictionsCache.containsKey((Object)cacheKey)) {
            return Boolean.valueOf((String)this.restrictionsCache.get((Object)cacheKey));
        }
        Page page = this.pageManager.getPage(pageId);
        boolean checkResult = page != null && this.hasInlineTableEditPermission(confluenceUser.getName(), page.getId(), page.getSpaceKey()) && this.permissionManager.hasPermissionNoExemptions(confluenceUser, Permission.EDIT, (Object)page);
        this.restrictionsCache.put((Object)cacheKey, (Object)String.valueOf(checkResult));
        return checkResult;
    }

    public boolean hasInlineTableEditPermission(String userName, Long pageId, String spaceKey) throws Exception {
        Integer size = 0;
        List<RestrictionModel> restrictions = this.getRestrictions(pageId, true);
        size = size + restrictions.size();
        if (this.hasPermission(restrictions, userName)) {
            return true;
        }
        restrictions = this.getRestrictions(spaceKey, true);
        size = size + restrictions.size();
        if (this.hasPermission(restrictions, userName)) {
            return true;
        }
        return size == 0;
    }

    private boolean hasPermission(List<RestrictionModel> restrictions, String userName) throws EntityException {
        List groups = this.userAccessor.getGroupNamesForUserName(userName);
        for (RestrictionModel restriction : restrictions) {
            if (StringUtils.equalsIgnoreCase((CharSequence)restriction.getUsers(), (CharSequence)userName)) {
                return true;
            }
            for (String userGroup : groups) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)userGroup, (CharSequence)restriction.getGroups())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUserHasRestriction(List<RestrictionModel> restrictionModels, String userNames) {
        if (StringUtils.isNotBlank((CharSequence)userNames)) {
            String userKeys = this.convertUserNamesToUserKeys(userNames);
            String[] userKeyArr = userKeys.split(",");
            for (RestrictionModel restrictionModel : restrictionModels) {
                for (String userKey : userKeyArr) {
                    for (String restrictionUserKey : restrictionModel.getUsers().split(",")) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)userKey, (CharSequence)restrictionUserKey)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isGroupHasRestriction(List<RestrictionModel> restrictionModels, String groupNames) {
        if (StringUtils.isNotBlank((CharSequence)groupNames)) {
            String[] groupNameArr = groupNames.split(",");
            for (RestrictionModel restrictionModel : restrictionModels) {
                for (String groupName : groupNameArr) {
                    for (String restrictionGroupName : restrictionModel.getGroups().split(",")) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)groupName, (CharSequence)restrictionGroupName)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

