/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.conf10.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.gson.Gson;
import de.actonic.confluence.ctipe.conf10.component.AppSettingsManager;
import de.actonic.confluence.ctipe.shared.model.UserSettings;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/userprofilepanel")
@Produces(value={"application/json"})
public class UserProfilePanelRest {
    private final AppSettingsManager appSettingsManager;
    private final Gson gson = new Gson();

    @Autowired
    public UserProfilePanelRest(AppSettingsManager appSettingsManager) {
        this.appSettingsManager = appSettingsManager;
    }

    @Path(value="settings")
    @GET
    @Consumes(value={"application/json"})
    public Response loadSettings() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            return Response.ok((Object)this.gson.toJson((Object)this.appSettingsManager.getUserSettings(confluenceUser))).build();
        }
        return Response.ok().build();
    }

    @Path(value="settings")
    @POST
    @Consumes(value={"application/json"})
    public Response saveSettings(UserSettings userSettings) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            this.appSettingsManager.setSettings(confluenceUser, userSettings);
        }
        return Response.ok().build();
    }
}

