/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.conf10.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.google.gson.Gson;
import de.actonic.confluence.ctipe.conf10.component.AppSettingsManager;
import de.actonic.confluence.ctipe.shared.model.Configuration;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/settings")
public class SettingsRest {
    private final AppSettingsManager appSettingsManager;
    @ComponentImport
    private final UserManager userManager;

    @Autowired
    public SettingsRest(AppSettingsManager appSettingsManager, UserManager userManager) {
        this.appSettingsManager = appSettingsManager;
        this.userManager = userManager;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response loadConfiguration() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            Configuration configuration = this.appSettingsManager.getSettingsForUser(confluenceUser);
            return Response.ok((Object)new Gson().toJson((Object)configuration)).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Anonymous user are not able to use Inline Table Editing features").build();
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response setConfiguration(Configuration configuration) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null && (this.userManager.isSystemAdmin(confluenceUser.getKey()) || this.userManager.isAdmin(confluenceUser.getKey()))) {
            this.appSettingsManager.saveSettings(configuration);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to get this data").build();
    }
}

