define("ite/inline-editing/utils", ["jquery"], function ($) {
    function Utils() {
        var _this = this;
        this.isStaticTablePresent = function () {
            return $('#main-content').find('tr').length;
        };
        this.checkAllowedTables = function (that) {
            return checkWhitelistedMacros(that) || (checkDynamicallyCreatedTable(that) && checkTableFilterAndCharts(that) && checkAdvancedTables(that) && _this.checkTableWrap(that));
        };
        checkWhitelistedMacros = function (that) {
            var macros = ['column', 'excerpt', 'expand', 'info', 'note', 'details' /* page-properties*/,
                'panel', 'section', 'tip', 'warning', 'presentation-slide', 'presentation-slide-fragment'];
            // check macros
            for (var i = 0; i < macros.length; i++) {
                if ($(that).parents('div.conf-macro').attr('data-macro-name') == macros[i]) {
                    return true;
                }
            }
            return false;
        };
        checkDynamicallyCreatedTable = function (that) {
            return !$(that).parents('div.conf-macro[data-hasbody="false"]').length;
        };
        checkTableFilterAndCharts = function (that) {
            var pluginClassNames = ['table-filter', 'pivot-table', 'table-chart', 'table-excerpt', 'table-excerpt-include', 'table-joiner'];
            for (var i = 0; i < pluginClassNames.length; i++) {
                if ($(that).parents('div.conf-macro[data-macro-name="' + pluginClassNames[i] + '"]').length > 0) {
                    return false;
                }
            }
            return true;
        };
        checkAdvancedTables = function (that) {
            if ($(that).parents('.appfire-table-plus-parms').length > 0) {
                return false;
            }
            return true;
        };

        this.checkTableWrap = function (that) {
            return $(that).parent().parent().parent().hasClass('table-wrap');
        };
        this.isElementOfDisabledTable = function (element) {
            return $(element).closest('table').hasClass('disable-inline-editing');
        };
        this.isElementOfIncludedTable = function (element) {
            //console.log("isElementOfIncludedTable = " + ($(element).parents('table:first').parents('td:first').length > 0));
            return $(element).parents('table:first').parents('td:first').length > 0;
        };
        this.increase = function (currentTrNumber) {
            return ++currentTrNumber;
        };
        this.decrease = function (currentTrNumber) {
            return --currentTrNumber;
        };
        this.uuidv4 = function () {
            var crypto = window.crypto || window.msCrypto;
            return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11).replace(/[018]/g, function (c) {
                return (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16);
            }
            )
        };
        this.getParentCell = function (element) {
            return $(element).closest('td,th');
        };
        this.getClickedCell = function (clickedSpan, event) {
            var $clickedSpan = $(clickedSpan);
            if ($clickedSpan.parents('th').length) {
                event.stopPropagation();
            }
            var $cell = $clickedSpan.closest('td,th');
            return $cell;
        };
        this.getTrNumber = function ($closestTr) {
            var tbody = $closestTr.parent();
            var table = tbody.parent();
            var visibleTrs = [];
            var allTheads = table.children('thead').toArray();
            var foundThead = allTheads.find((thead) => {
                return $(thead).hasClass('tableFloatingHeaderOriginal') || !$(thead).attr('class');
            }) || allTheads[0];
            visibleTrs = visibleTrs.concat($(foundThead).children('tr').toArray());
            visibleTrs = visibleTrs.concat(tbody.children('tr').toArray());
            return visibleTrs.indexOf($closestTr[0]);
        };
        this.getTableNumber = function (closestTr) {
            //console.log("table.ite-marked-table.ite-real-table length = " + $('table.ite-marked-table.ite-real-table').length);
            return $('#main-content table.ite-marked-table.ite-real-table, #main-content .ite-shadow-view table').filter(function (index) {
                return $(this).parents('ul.dragtable-sortable.ui-sortable.ui-sortable-disabled.dragtable-disabled').length === 0;
            })/*.filter(function (index) {
                return _this.checkAllowedTables(this);
                // TODO
                /!*return $(this).parents('div.conf-macro[data-hasbody="false"]').length === 0 &&
                    $(this).parents('ul.dragtable-sortable.ui-sortable.ui-sortable-disabled.dragtable-disabled').length === 0;*!/
            })*/.index(closestTr.closest("table"));
        };
        this.updateTableFilterPanel = function (table) {
            var offset = table.offset();
            var parent = table.parent();
            $('.tfac-macro-inserter').offset({
                top: offset?.top,
                left: Math.max(offset?.left, parent.offset()?.left) + Math.min(table.width(), parent.width()) + 5
            });
        };
        this.setTdWidthAndUpdateTableFilterPanel = function ($td, value) {
            $td.width(value);
            _this.updateTableFilterPanel($td.closest('table'));
        };
        this.isItCurrentPageVersion = function () {
            return AJS.Meta.get('latest-page-id') === AJS.Meta.get('page-id');
        };

        this.getFirstTD = function ($td) {
            return $td.closest('tr').children().first();
        };

        this.getLastTD = function ($td) {
            return $td.closest('tr').children().last();
        };

        this.getTH = function ($td) {
            $tr = $td.closest('table').find('tr[ite-row-number=0]:first');
            if ($tr.find('th[ite-col-number=' + $td.attr('ite-col-number') + ']').length) {
                return $tr.find('th[ite-col-number=' + $td.attr('ite-col-number') + ']');
            }
            return $tr.find('td[ite-col-number=' + $td.attr('ite-col-number') + ']');
        };
    }

    return new Utils();
});
