require(["jquery", "ite/domReady", "ite/core/flags", "ite/user-profile-panel/rest"], function ($, domReady, flags, rest) {
    "use strict";

    var btnOnEachPage;
    var btnByDoubleClicking;
    var settings;

    domReady(function () {
        //console.log("User Profile Panel init");

        btnOnEachPage = $("#ite-settings-btn-on-each-page");
        btnByDoubleClicking = $("#ite-settings-btn-by-double-clicking");

        btnOnEachPage.click(function(e) {
            e.preventDefault();
            settings.onEachPage = !settings.onEachPage;
            rest.saveSettings(settings, function() {
                loadSettings();
            }, function() {
                flags.simpleWarning("Failed to save Inline Table Editing plugin settings");
            });
        });
        btnByDoubleClicking.click(function(e) {
            e.preventDefault();
            settings.byDoubleClicking = !settings.byDoubleClicking;
            rest.saveSettings(settings, function() {
                loadSettings();
            }, function() {
                flags.simpleWarning("Failed to save Inline Table Editing plugin settings");
            });
        });

        loadSettings();
    });

    function loadSettings() {
        rest.loadSettings(function(data) {
            settings = data;
            //console.log(settings);
            if (settings) {
                reviewButtons();
                btnOnEachPage.removeAttr("disabled");
                btnByDoubleClicking.removeAttr("disabled");
            }
        }, function() {
            flags.simpleWarning("Failed to load Inline Table Editing plugin settings");
        });
    };

    function reviewButtons() {
        btnOnEachPage.html(settings.onEachPage ? "On" : "Off");
        btnByDoubleClicking.html(settings.byDoubleClicking ? "On" : "Off");
        btnOnEachPage.removeClass("aui-button-primary");
        btnByDoubleClicking.removeClass("aui-button-primary");
        if (settings.onEachPage) {
            btnOnEachPage.addClass("aui-button-primary");
        }
        if (settings.byDoubleClicking) {
            btnByDoubleClicking.addClass("aui-button-primary");
        }
    };
});