define('ite/restrictions/rest', ['jquery', 'ajs'], function($, AJS) {
    var Rest = function () {
        this.getPageRestrictions = function(pageId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/ctiperestresource/1.0/restriction/page/" + pageId,
                success: function(data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }

        this.savePageRestriction = function(params, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/ctiperestresource/1.0/restriction/page",
                data: params,
                success: function() {
                    if (typeof successCallback === "function") successCallback();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }

        this.updatePageRestriction = function (params, successCallbback, errorCallback) {
            $.ajax({
                type: "PUT",
                url: AJS.contextPath() + "/rest/ctiperestresource/1.0/restriction/page",
                data: params,
                success: function() {
                    if (typeof successCallback === "function") successCallback();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
    }

    return new Rest();
});