/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.component;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.opensymphony.module.propertyset.PropertySet;
import de.actonic.confluence.ctipe.model.Configuration;
import de.actonic.confluence.ctipe.model.UserSettings;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppSettingsManager {
    private static final Logger log = LoggerFactory.getLogger(AppSettingsManager.class);
    private final String CACHE_NAME = "inline-table-editing-user-settings-cache";
    private final String ALWAYS_SHOW_KEY = "always-show-icons";
    private final String BUTTON_LAYOUT = "button-layout";
    private final String ENABLED_FOR = "enable-for";
    private final String SELECTED_SPACES = "selected-spaces";
    private final String ENABLE_DRAFT_CHECKING = "enable-draft-checking";
    private final String ENABLE_ERROR_TRACKING = "enable-error-tracking";
    private final String PROPERTY_ON_EACH_PAGE = "sal_ite-user-settings-on-each-page";
    private final String PROPERTY_BY_DOUBLE_CLICKING = "sal_ite-user-settings-by-double-clicking";
    private final String MACRO_ICON_VISIBILITY = "macro-icon-visibility";
    private final String AMPLITUDE_STATISTICS = "amplitude-statistics";
    private final Cache<String, String> settingsCache;
    private final PluginSettings pluginSettings;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Autowired
    public AppSettingsManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, @ComponentImport CacheManager cacheManager) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(this.getClass().getPackage().toString());
        this.userAccessor = userAccessor;
        this.settingsCache = cacheManager.getCache("inline-table-editing-user-settings-cache");
        this.invalidateCache();
    }

    public String getEnabledFor() {
        String enabledFor = (String)this.pluginSettings.get("enable-for");
        return StringUtils.isNotBlank((CharSequence)enabledFor) ? enabledFor : "allSpaces";
    }

    public void setEnabledFor(String enabledFor) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("enable-for", (Object)enabledFor);
    }

    public String getSelectedSpaces() {
        String selectedSpaces = (String)this.pluginSettings.get("selected-spaces");
        return StringUtils.isNotBlank((CharSequence)selectedSpaces) ? selectedSpaces : "";
    }

    public void setSelectedSpaces(String selectedSpaces) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("selected-spaces", (Object)selectedSpaces);
    }

    public Boolean getAlwaysShowIcons() {
        return Boolean.valueOf((String)this.pluginSettings.get("always-show-icons"));
    }

    public void setAlwaysShowIcons(Boolean alwaysShowIcons) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("always-show-icons", (Object)alwaysShowIcons.toString());
    }

    public Boolean getEnableDraftChecking() {
        Object enableDraftChecking = this.pluginSettings.get("enable-draft-checking");
        return enableDraftChecking == null ? true : Boolean.valueOf((String)enableDraftChecking);
    }

    public void setEnableDraftChecking(Boolean enableDraftChecking) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("enable-draft-checking", (Object)enableDraftChecking.toString());
    }

    public Boolean getEnableErrorTracking() {
        Object enableErrorTracking = this.pluginSettings.get("enable-error-tracking");
        return enableErrorTracking == null ? true : Boolean.valueOf((String)enableErrorTracking);
    }

    public void setErrorTracking(Boolean enableErrorTracking) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("enable-error-tracking", (Object)enableErrorTracking.toString());
    }

    public String getButtonLayout() {
        String result = (String)this.pluginSettings.get("button-layout");
        return StringUtils.isNotBlank((CharSequence)result) ? result : "left";
    }

    public void setButtonLayout(String layout) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("button-layout", (Object)layout);
    }

    public Boolean getMacroIconVisibility() {
        Object obj = this.pluginSettings.get("macro-icon-visibility");
        return obj == null || Boolean.parseBoolean((String)obj);
    }

    public void setMacroIconVisibility(Boolean visibility) {
        this.pluginSettings.put("macro-icon-visibility", (Object)String.valueOf(visibility));
    }

    public Boolean getAmplitudeStatistics() {
        Object amplitudeStatistics = this.pluginSettings.get("amplitude-statistics");
        return amplitudeStatistics == null || Boolean.valueOf((String)amplitudeStatistics) != false;
    }

    public void setAmplitudeStatistics(Boolean amplitudeStatistics) {
        this.settingsCache.removeAll();
        this.pluginSettings.put("amplitude-statistics", (Object)amplitudeStatistics.toString());
    }

    public void saveSettings(Configuration configuration) {
        this.settingsCache.removeAll();
        String buttonLayout = configuration.getBtnLayout();
        String enableFor = configuration.getEnabledFor();
        String selectedSpaces = configuration.getSelectedSpaces();
        boolean enableDraftChecking = configuration.getEnableDraftChecking();
        boolean enableErrorTracking = configuration.getEnableErrorTracking();
        boolean alwaysShowIcons = configuration.getAlwaysShowIcons();
        boolean macroIconVisibility = configuration.getMacroIconVisibility();
        boolean amplitudeStatistics = configuration.getAmplitudeStatistics();
        if (buttonLayout != null) {
            this.setButtonLayout(buttonLayout);
        } else {
            this.setButtonLayout("left");
        }
        if (selectedSpaces != null) {
            this.setSelectedSpaces(selectedSpaces);
        } else {
            this.setSelectedSpaces("");
        }
        this.setEnabledFor(enableFor);
        this.setEnableDraftChecking(enableDraftChecking);
        this.setErrorTracking(enableErrorTracking);
        this.setAlwaysShowIcons(alwaysShowIcons);
        this.setMacroIconVisibility(macroIconVisibility);
        this.setAmplitudeStatistics(amplitudeStatistics);
    }

    public Configuration getSettingsForUser(ConfluenceUser confluenceUser) {
        String cacheKey;
        String string = cacheKey = confluenceUser == null ? "null" : confluenceUser.getKey().getStringValue();
        if (this.settingsCache.containsKey((Object)cacheKey)) {
            return this.getCachedSettings(cacheKey);
        }
        Configuration configuration = this.getNewSettings(confluenceUser);
        String responseContent = new Gson().toJson((Object)configuration);
        this.settingsCache.put((Object)cacheKey, (Object)responseContent);
        return configuration;
    }

    private Configuration getCachedSettings(String cacheKey) {
        String configurationAsString = (String)this.settingsCache.get((Object)cacheKey);
        Type type = new TypeToken<Configuration>(){}.getType();
        Configuration configuration = (Configuration)new Gson().fromJson(configurationAsString, type);
        return configuration;
    }

    public void invalidateCache() {
        this.settingsCache.removeAll();
    }

    private Configuration getNewSettings(ConfluenceUser confluenceUser) {
        UserSettings settings = this.getUserSettings(confluenceUser);
        String buttonLayout = this.getButtonLayout();
        String enableFor = this.getEnabledFor();
        String selectedSpaces = this.getSelectedSpaces();
        boolean enableDraftChecking = this.getEnableDraftChecking();
        boolean enableErrorTracking = this.getEnableErrorTracking();
        boolean alwaysShowIcons = this.getAlwaysShowIcons();
        boolean macroIconVisibility = this.getMacroIconVisibility();
        boolean amplitudeStatistics = this.getAmplitudeStatistics();
        Configuration configuration = Configuration.builder().btnLayout(buttonLayout).enabledFor(enableFor).selectedSpaces(selectedSpaces).enableDraftChecking(enableDraftChecking).enableErrorTracking(enableErrorTracking).alwaysShowIcons(alwaysShowIcons).onEachPage(settings.isOnEachPage()).byDoubleClicking(settings.isByDoubleClicking()).macroIconVisibility(macroIconVisibility).amplitudeStatistics(amplitudeStatistics).build();
        return configuration;
    }

    public UserSettings getUserSettings(ConfluenceUser confluenceUser) {
        UserSettings mySettings;
        PropertySet userPropertySet = this.userAccessor.getPropertySet(confluenceUser);
        if (!this.isPropertyExists(userPropertySet).booleanValue()) {
            mySettings = this.getDefaultSettings(confluenceUser);
            this.setSettings(confluenceUser, mySettings);
        } else {
            mySettings = UserSettings.builder().onEachPage(userPropertySet.getBoolean("sal_ite-user-settings-on-each-page")).byDoubleClicking(userPropertySet.getBoolean("sal_ite-user-settings-by-double-clicking")).selectedSpaces(this.getSelectedSpaces()).build();
        }
        return mySettings;
    }

    public void setSettings(ConfluenceUser confluenceUser, UserSettings settings) {
        PropertySet userPropertySet = this.userAccessor.getPropertySet(confluenceUser);
        userPropertySet.setBoolean("sal_ite-user-settings-on-each-page", settings.isOnEachPage());
        userPropertySet.setBoolean("sal_ite-user-settings-by-double-clicking", settings.isByDoubleClicking());
        this.invalidateCache();
    }

    private UserSettings getDefaultSettings(ConfluenceUser confluenceUser) {
        PropertySet userPropertySet = this.userAccessor.getPropertySet(confluenceUser);
        UserSettings userSettings = UserSettings.builder().onEachPage(userPropertySet.exists("sal_ite-user-settings-on-each-page") ? userPropertySet.getBoolean("sal_ite-user-settings-on-each-page") : true).byDoubleClicking(userPropertySet.exists("sal_ite-user-settings-by-double-clicking") ? userPropertySet.getBoolean("sal_ite-user-settings-by-double-clicking") : true).selectedSpaces(this.getSelectedSpaces()).build();
        return userSettings;
    }

    public Boolean isPropertyExists(ConfluenceUser user) {
        PropertySet propertySet = this.userAccessor.getPropertySet(user);
        return this.isPropertyExists(propertySet);
    }

    public Boolean isPropertyExists(PropertySet propertySet) {
        return propertySet != null && propertySet.exists("sal_ite-user-settings-on-each-page") && propertySet.exists("sal_ite-user-settings-by-double-clicking");
    }
}

