define('ite/user-profile-panel/rest', ['jquery', 'ajs'], function ($, AJS) {
    var Rest = function () {
        this.loadSettings = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/ctiperestresource/1.0/userprofilepanel/settings",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            });
        };

        this.saveSettings = function (settings, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                url: AJS.contextPath() + "/rest/ctiperestresource/1.0/userprofilepanel/settings",
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                data: JSON.stringify(settings),
                success: function () {
                    if (typeof successCallback === "function") successCallback();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR.responseText);
                }
            })
        }
    };

    return new Rest();
});