/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.encoder;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class URIEncoder {
    private static final String CHARSET = StandardCharsets.UTF_8.name();

    public static String encodeURIComponent(String text) {
        String code;
        if (text.isEmpty()) {
            return "";
        }
        try {
            code = URLEncoder.encode(text, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int textLength = text.length();
        int codeLength = code.length();
        StringBuilder builder = new StringBuilder((textLength + codeLength + 1) / 2);
        block16: for (int i = 0; i < codeLength; ++i) {
            char entry = code.charAt(i);
            switch (entry) {
                case '+': {
                    builder.append("%20");
                    continue block16;
                }
                case '%': {
                    if (i > codeLength - 2) continue block16;
                    char a = code.charAt(++i);
                    char b = code.charAt(++i);
                    switch (a) {
                        case '2': {
                            switch (b) {
                                case '1': {
                                    builder.append("!");
                                    continue block16;
                                }
                                case '7': {
                                    builder.append("'");
                                    continue block16;
                                }
                                case '8': {
                                    builder.append("(");
                                    continue block16;
                                }
                                case '9': {
                                    builder.append(")");
                                    continue block16;
                                }
                            }
                            builder.append("%");
                            builder.append(a);
                            builder.append(b);
                            continue block16;
                        }
                        case '7': {
                            if (b == 'e' || b == 'E') {
                                builder.append("~");
                                continue block16;
                            }
                            builder.append("%");
                            builder.append(a);
                            builder.append(b);
                            continue block16;
                        }
                    }
                    builder.append("%");
                    builder.append(a);
                    builder.append(b);
                    continue block16;
                }
                default: {
                    builder.append(entry);
                }
            }
        }
        return builder.toString();
    }
}

