define("ite/inline-editing/rest", ["jquery", "ite/inline-editing/messenger", "ite/core/flags"], function ($, messenger, flags) {
    function Rest() {
        this.action = function (dataToSend, endpoint, type, operation, successHandler) {
            messenger.restActionStart();
            $.ajax({
                url: Confluence.getBaseUrl() + '/rest/ctiperestresource/1.0/' + endpoint,
                type: type,
                dataType: 'json',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify(dataToSend),
                success: function (data) {
                    if (successHandler !== undefined) {
                        successHandler(data);
                    }
                    messenger.restActionSuccess(data);
                },
                error: function (xhr, statusText, errorThrown) {
                    messenger.restActionError({
                        dataToSend: dataToSend,
                        endpoint: endpoint,
                        operation: operation,
                        xhr: xhr,
                    });
                }
            });
        };

        this.getConfiguration = function (pageId) {
            $.ajax({
                url: AJS.contextPath() + '/rest/ctiperestresource/1.0/page/' + pageId,
                type: 'GET',
                success: function (data) {
                    messenger.restGetConfigSuccess(data);
                },
                error: function (xhr, statusText, errorThrown) {
                    messenger.restGetConfigError({xhr: xhr});
                }
            });
        };

        this.saveConfiguration = function (data) {
            $.ajax({
                url: AJS.contextPath() + '/rest/ctiperestresource/1.0/settings',
                type: 'POST',
                dataType: 'json',
                contentType: 'application/json; charset=utf-8',
                data: JSON.stringify(data),
                success: function (data) {
                    flags.simpleSuccess('Configuration successfully updated.')
                },
                error: function () {
                    flags.simpleWarning('Something goes wrong. Please contact your Confluence administrator!');
                }
            });
        };

        /*this.loadConfiguration = function (callback) {
            $.ajax({
                url: AJS.contextPath() + '/rest/ctiperestresource/1.0/configuration',
                type: 'GET',
                // dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                // data: JSON.stringify(data),
                success: function (data) {
                    callback(data);
                },
                error: function () {
                    flags.simpleWarning('Something goes wrong. Please contact your Confluence administrator!');
                }
            });
        };*/

        this.loadSettings = function (callback) {
            $.ajax({
                url: AJS.contextPath() + '/rest/ctiperestresource/1.0/settings',
                type: 'GET',
                success: function (data) {
                    callback(data);
                },
                error: function (jqXHR) {
                    if (jqXHR.status && (jqXHR.status == 401 || jqXHR.status == 403)) {
                        console.error('/rest/ctiperestresource/1.0/settings', jqXHR.responseText);
                    } else {
                        flags.simpleWarning('Something goes wrong while getting app settings. Please contact your Confluence administrator!');
                    }
                }
            });
        };
    }

    return new Rest();
});