define("inline-table/config", ["jquery", "ite/inline-editing/rest"], function ($, rest) {
    function Configuration() {
        this.init = function () {
            $("#save").on("click", function (event) {
                event.preventDefault();
                let enableDraftChecking = $('#enable-draft-checking').prop('checked');
                let enableErrorTracking = $('#enable-error-tracking').prop('checked');
                let macroIconVisibility = $('#macro-icon-visibility').prop('checked');
                let amplitudeStatistics = $('#amplitude-statistics').prop('checked');
                let btnLayout = $('#button-left').prop('checked') ? 'left' : 'right';

                let enabledFor = $('input[name="enabledFor"]:checked')[0].id;
                let selectedSpaces = $("#space-picker").val();

                rest.saveConfiguration({
                    alwaysShowIcons: false,
                    btnLayout,
                    enabledFor,
                    selectedSpaces,
                    enableDraftChecking,
                    enableErrorTracking,
                    macroIconVisibility,
                    amplitudeStatistics
                });
            });

            $('#allSpaces').click(function () {
                $("#space-picker").val([]).trigger("change");
                $("#space-picker").prop('disabled', true);
                hideEmptySpacesError();
            });

            $('#selectedSpaces, #exceptedSpaces').click(function () {
                $("#space-picker").val([]).trigger("change");
                $("#space-picker").prop('disabled', false);
                showEmptySpacesError();
            });

            this.loadConfig();
        };

        this.loadConfig = function () {
            rest.loadSettings((data) => {
                let configObj = data;

                if (configObj.btnLayout === 'left') $('#button-left').prop('checked', true);
                if (configObj.btnLayout === 'right') $('#button-right').prop('checked', true);

                $('#enable-draft-checking').prop('checked', configObj.enableDraftChecking);
                $('#enable-error-tracking').prop('checked', configObj.enableErrorTracking);
                $('#macro-icon-visibility').prop('checked', configObj.macroIconVisibility);
                $('#amplitude-statistics').prop('checked', configObj.amplitudeStatistics);

                $("#" + configObj.enabledFor).prop('checked', true);
                if (configObj.enabledFor === "allSpaces") {
                    this.initializeSpacePicker();

                    $("#space-picker").prop('disabled', true);
                    hideEmptySpacesError();
                } else {
                    let initialValuesArr = configObj.selectedSpaces.split(',');

                    this.initializeSpacePicker(initialValuesArr);

                    $("#space-picker").prop('disabled', false);
                    initialValuesArr.length === 0 && showEmptySpacesError();
                }
            });
        };

        this.initializeSpacePicker = function (initialSpaceKeys) {
            $("#s2id_space-picker").remove();
            $('#space-picker').replaceWith("<input type=\"text\" class=\"select long-field\" id=\"space-picker\">");

            $('#space-picker').change(function () {
                $(this).val().length === 0 && !$('#allSpaces').is(':checked')
                    ? showEmptySpacesError()
                    : hideEmptySpacesError();
            });

            var initialValues = [];
            var initialNames = [];
            if (initialSpaceKeys) {
                initialSpaceKeys.forEach(function (userName) {
                    initialValues.push({id: userName, text: userName});
                    initialNames.push(userName);
                });
            }

            AJS.$("#space-picker").auiSelect2({
                placeholder: AJS.I18n.getText("configure.page.form.spaces.placeholder"),
                containerCssClass: 'space-picker-container',
                allowClear: true,
                multiple: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/ctiperestresource/1.0/picker/spaces",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (initialSpaceKeys) {
                        callback(initialValues);
                    }
                }
            });

            if (initialSpaceKeys) {
                $("#space-picker").val(initialNames).trigger("change");
            }
        }

        function showEmptySpacesError() {
            $('#save').prop('disabled', true);
            $('#space-picker').addClass('has-error');
        }

        function hideEmptySpacesError() {
            $('#save').prop('disabled', false);
            $('#space-picker').removeClass('has-error');
        }
    }

    return new Configuration();
});