define('ite/restrictions/model/restriction-collection', ['jquery', 'ajs', 'backbone', 'underscore', 'ite/restrictions/model/restriction'],
    function ($, AJS, Backbone, _, Restriction) {
        "use strict";

        //var _this;
        var RestrictionCollection = Backbone.Collection.extend({
            model: Restriction,

            url: function () {
                var contextPage = AJS.contextPath();
                var spaceKey = AJS.Meta.get("space-key");
                var pageId = AJS.Meta.get("page-id") || -1;
                if (!pageId) pageId = -1;
                return contextPage + "/rest/ctiperestresource/1.0/restrictions/" + spaceKey + "/" + pageId;
            },

            initialize: function (options) {
                //_this = this;
            },

            removeAll: function (options) {
                $.ajax({
                    url: AJS.contextPath() + "/rest/ctiperestresource/1.0/restrictions/" + options.type + "/" + options.path,
                    type: "DELETE",
                    success: function () {
                        if (typeof options.successCallback === "function") return options.successCallback();
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        if (typeof options.errorCallback === "function") options.errorCallback(jqXHR.responseText);
                    }
                })
            },

            getEntitiesSize: function (options) {
                return this.filter(function (el) {
                    return el.get("entityType") === options.entityType;
                }).length;
            }
        })

        return RestrictionCollection;
    }
)