/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.upgrade.v1;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import de.actonic.confluence.ctipe.component.AppSettingsManager;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SettingsUpgrade001
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SettingsUpgrade001.class);
    private final AppSettingsManager appSettingsManager;

    public SettingsUpgrade001(AppSettingsManager appSettingsManager) {
        this.appSettingsManager = appSettingsManager;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Upgrades ITE settings to new format";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.debug("Start upgrading...");
        String selectedSpaces = this.appSettingsManager.getSelectedSpaces();
        log.debug("Current list of selected spaces = '" + selectedSpaces + "'");
        String enabledFor = StringUtils.isNotBlank((CharSequence)selectedSpaces) ? "selectedSpaces" : "allSpaces";
        log.debug("will be set enabledFor = " + enabledFor);
        log.debug("saving...");
        this.appSettingsManager.setEnabledFor(enabledFor);
        log.debug("Done.");
        return Collections.emptySet();
    }

    public String getPluginKey() {
        return "de.actonic.inline-table-editing";
    }
}

