/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.rest;

import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.ctipe.component.ActonicLicenseService;
import de.actonic.confluence.ctipe.component.RestrictionService;
import de.actonic.confluence.ctipe.converter.ContentBodyConverter;
import de.actonic.confluence.ctipe.model.BulkUpdate;
import de.actonic.confluence.ctipe.model.TableUpdate;
import de.actonic.confluence.ctipe.model.TableUpdateResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="")
public class TablesRestResource {
    private static final Logger log = LoggerFactory.getLogger(TablesRestResource.class);
    private static final String LAST_MODIFIED_UUID = "last-modified-uuid";
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final ContentPropertyManager contentPropertyManager;
    private final ContentBodyConverter contentBodyConverter;
    private final ActonicLicenseService actonicLicenseService;
    private final RestrictionService restrictionService;

    @Autowired
    public TablesRestResource(PageManager pageManager, PermissionManager permissionManager, ContentBodyConverter contentBodyConverter, ContentPropertyManager contentPropertyManager, ActonicLicenseService actonicLicenseService, RestrictionService restrictionService, @ComponentImport CacheManager cacheManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.contentBodyConverter = contentBodyConverter;
        this.contentPropertyManager = contentPropertyManager;
        this.actonicLicenseService = actonicLicenseService;
        this.restrictionService = restrictionService;
    }

    private static List<Element> getChildrenByTags(Element element, Collection<String> tagNames) {
        return element.children().stream().filter(el -> tagNames.contains(el.tagName())).collect(Collectors.toList());
    }

    @Path(value="page")
    @DELETE
    @Consumes(value={"application/json"})
    public Response removeRow(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        int trNumber = tableUpdate.getTrNumber();
        Element tr = trs.get(trNumber);
        tr.remove();
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="move/row")
    @PUT
    public Response moveRow(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        int fromTrNumber = tableUpdate.getFromTrNumber();
        Element movingTr = trs.get(fromTrNumber);
        int toTrNumber = tableUpdate.getToTrNumber();
        Element targetTr = trs.get(toTrNumber);
        targetTr.before((Node)movingTr);
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="move/column")
    @PUT
    public Response moveColumn(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        int fromColumnNumber = tableUpdate.getFromColumnNumber();
        int toColumnNumber = tableUpdate.getToColumnNumber();
        for (Element row : trs) {
            List<Element> cells = TablesRestResource.getChildrenByTags(row, Arrays.asList("td", "th"));
            Element movingCell = cells.get(fromColumnNumber);
            Element targetCell = cells.get(toColumnNumber);
            targetCell.before((Node)movingCell);
        }
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="paint/cell")
    @POST
    public Response paintCell(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        Element cell = this.getClickedCell(tableUpdate, document);
        String prevTdColor = cell.attr("data-highlight-colour");
        if (!StringUtils.isEmpty((CharSequence)prevTdColor)) {
            cell.removeAttr("data-highlight-colour");
            cell.removeClass("highlight-" + prevTdColor);
        }
        if (!StringUtils.isEmpty((CharSequence)tableUpdate.getTdColor())) {
            cell.attr("data-highlight-colour", tableUpdate.getTdColor());
            cell.addClass("highlight-" + tableUpdate.getTdColor());
        }
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="merge")
    @POST
    public Response mergeTwoCells(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        Element tr = trs.get(tableUpdate.getTrNumber());
        List<Element> cells = TablesRestResource.getChildrenByTags(tr, Arrays.asList("td", "th"));
        Element firstCell = cells.get(tableUpdate.getTdNumber());
        Element secondCell = cells.get(tableUpdate.getTdNumber() + 1);
        firstCell.attr("colspan", tableUpdate.getColspan().toString());
        firstCell.append(secondCell.html());
        secondCell.remove();
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="split")
    @POST
    public Response splitCell(TableUpdate tableUpdate) {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        Element cell = this.getClickedCell(tableUpdate, document);
        int colspan = Integer.parseInt(cell.attr("colspan"));
        cell.attr("colspan", NumberUtils.BYTE_ONE.toString());
        for (int i = 1; i < colspan; ++i) {
            Element cloned = cell.shallowClone().empty();
            cell.after((Node)cloned);
        }
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    private Element getClickedCell(TableUpdate tableUpdate, Document document) {
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        Element tr = trs.get(tableUpdate.getTrNumber());
        List<Element> cells = TablesRestResource.getChildrenByTags(tr, Arrays.asList("td", "th"));
        return cells.get(tableUpdate.getTdNumber());
    }

    private Response saveNewPageVersion(Page page, Document document, String uuid) {
        this.pageManager.saveNewVersion((ContentEntityObject)page, modificationPage -> modificationPage.setBodyAsString(document.body().html()));
        this.contentPropertyManager.setStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID, uuid);
        return Response.ok((Object)new TableUpdateResponse(page.getVersion())).build();
    }

    @Path(value="page")
    @POST
    @Consumes(value={"application/json"})
    public Response getMessage(TableUpdate tableUpdate) throws XhtmlException {
        Page page = this.pageManager.getPage(tableUpdate.getPageId().longValue());
        if (!tableUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > tableUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
        int trNumber = tableUpdate.getTrNumber();
        if (!tableUpdate.getNewRow().booleanValue()) {
            Element tr = trs.get(trNumber);
            String converted = this.contentBodyConverter.convert(tableUpdate.getNewData().get(0), page);
            TablesRestResource.getChildrenByTags(tr, Arrays.asList("td", "th")).get(tableUpdate.getTdNumber()).html(converted);
        } else {
            Element tr = trs.get(trNumber - 1);
            String trHtml = String.join((CharSequence)"", tableUpdate.getNewData());
            tr.after("<tr>" + trHtml + "</tr>");
        }
        return this.saveNewPageVersion(page, document, tableUpdate.getUuidv4());
    }

    @Path(value="bulkUpdate")
    @POST
    public Response bulkUpdate(BulkUpdate bulkUpdate) {
        Page page = this.pageManager.getPage(bulkUpdate.getPageId().longValue());
        if (!bulkUpdate.getUuidv4().equals(this.contentPropertyManager.getStringProperty((ContentEntityObject)page, LAST_MODIFIED_UUID)) && page.getVersion() > bulkUpdate.getPageVersion()) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        Document document = Jsoup.parse((String)page.getBodyAsString());
        document.outputSettings().prettyPrint(false);
        for (TableUpdate tableUpdate : bulkUpdate.getUpdates()) {
            List<Element> trs = this.getTableTrs(tableUpdate.getTableNumber(), document);
            Element tr = trs.get(tableUpdate.getTrNumber());
            Integer colspan = tableUpdate.getColspan();
            List<Element> cells = TablesRestResource.getChildrenByTags(tr, Arrays.asList("td", "th"));
            if (Objects.isNull(colspan)) {
                if (tableUpdate.getRemove().booleanValue()) {
                    cells.get(tableUpdate.getTdNumber()).remove();
                    continue;
                }
                String newData = tableUpdate.getNewData().get(0);
                if (tableUpdate.getInsertBefore().booleanValue()) {
                    cells.get(tableUpdate.getTdNumber()).before(newData);
                    continue;
                }
                cells.get(tableUpdate.getTdNumber() - 1).after(newData);
                continue;
            }
            cells.get(tableUpdate.getTdNumber()).attr("colspan", colspan.toString());
        }
        return this.saveNewPageVersion(page, document, bulkUpdate.getUuidv4());
    }

    private List<Element> getTableTrs(Integer tableNumber, Document document) {
        List<Element> tbody;
        Element table = (Element)document.getElementsByTag("table").get(tableNumber.intValue());
        List<Element> thead = TablesRestResource.getChildrenByTags(table, Collections.singleton("thead"));
        LinkedList<Element> trs = new LinkedList<Element>();
        if (thead.size() > 0) {
            trs.addAll(TablesRestResource.getChildrenByTags(thead.get(0), Collections.singleton("tr")));
        }
        if ((tbody = TablesRestResource.getChildrenByTags(table, Collections.singleton("tbody"))).size() > 0) {
            trs.addAll(TablesRestResource.getChildrenByTags(tbody.get(0), Collections.singleton("tr")));
        }
        return trs;
    }

    @GET
    @Path(value="page/{id}")
    @Produces(value={"application/json"})
    public Response checkLicense(@PathParam(value="id") Long pageId) throws Exception {
        if (this.actonicLicenseService.isLicenseValid()) {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            if (this.restrictionService.isUserAllowedToUseInlineEditingForPage(confluenceUser, pageId)) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to edit table inline").build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

