define("ite/inline-editing/editor", ["jquery", "ite/inline-editing/utils", "ite/inline-editing/messenger"], function ($, utils, messenger) {

    function Editor() {
        var _this = this;
        var _owner;
        var _currentCell;
        var _currentCellContent;
        var _showing = false;
        var _editActions;
        var _btnSave;
        var _btnCancel;
        var _scrollTop;

        this.init = function (owner) {
            _owner = owner;
        };

        this.show = function ($td) {
            if (_showing) {
                return;
            }

            AJS.Confluence.QuickEdit.QuickComment.proceedWithActivation().done(function () {
                _currentCell = $td;
                _currentCellContent = _currentCell.html();
                _currentCell.closest('table').find('td, th').removeClass('ite-editing-cell');
                _currentCell.addClass('ite-editing-cell');

                window.initialCellWidth = $td.width();
                $td.closest('.table-wrap').css('overflow-y', 'hidden');
                _owner.savePrevContentTD($td);
                $td.empty();
                $td.append('<div></div>');
                var $comment = $td.find('div');

                _handleTransition($comment);

                var $container = $comment.next('.quick-comment-container');

                AJS.Confluence.QuickEdit.activateEditor({
                    $container: $container,
                    $form: $('form.quick-comment-form[name=editcommentform]'),
                    fetchContent: _this.fetchCommentContent($td, 'editor'),
                    preInitialise: _preInitialise,
                    postInitialise: _postInitialise,
                    saveHandler: AJS.Confluence.QuickEdit.QuickComment.createSaveHandler(AJS.Confluence.QuickEdit.QuickComment.delegatingSaveCommentHandler, AJS.Confluence.QuickEdit.QuickComment.saveCommentErrorHandler),
                    cancelHandler: AJS.Confluence.QuickEdit.QuickComment.cancelHandler,
                    plugins: AJS.Confluence.Editor._Profiles.createProfileForCommentEditor().plugins,
                    postDeactivate: _cleanResource,
                    additionalResources: ['wrc!comment-editor'],
                    timeoutResources: AJS.Confluence.QuickEdit.QuickComment.timeout
                });

                $('#savebar-container').remove();
                window.toolbar = $('#toolbar');
                window.mainHeader = $('#main-header');

                var observer = new MutationObserver(function (mutations) {
                    mutations.forEach(_updateToolbarTop);
                });

                var target = document.getElementById('main-header');
                observer.observe(target, { attributes: true, attributeFilter: ['style'] });

                _addCellApproveCancelButtons($td);
            });
        };

        this.fetchCommentContent = function (td, expand) {
            var responseDeferred = new $.Deferred();

            var closestTr = td.closest('tr');
            var tableNumber = utils.getTableNumber(closestTr);
            var trNumber = closestTr.data('trNumber');
            var tdNumber = td.parent().children().index(td);

            $.ajax({
                url: AJS.contextPath() + '/rest/api/content/' + AJS.Meta.get('page-id') + '?expand=body.' + expand,
                cache: false
            }).done(function (data) {
                if (!data || !data.body || (!data.body.editor && !data.body.view)) {
                    responseDeferred.reject('invalid response from loading comment rest endpoint');
                } else {
                    var body = data.body.editor;
                    if (body === undefined) {
                        body = data.body.view;
                    }
                    var value = body.value;
                    const tableSelector = expand === 'view' ? ':not(.ite-shadow-editor) > .confluenceTable' : 'table:not(.wysiwyg-macro)'; // server uses getElementsByTagName('table') for editor content
                    var table = $($('<div>' + value + '</div>').find(tableSelector)[tableNumber]);
                    var visibleTrs = [];
                    visibleTrs = visibleTrs.concat(table.children('.tableFloatingHeaderOriginal').children('tr').toArray());
                    if (visibleTrs.length === 0) {
                        visibleTrs = visibleTrs.concat(table.children('thead').children('tr').toArray());
                    }
                    visibleTrs = visibleTrs.concat(table.children('tbody').children('tr').toArray());
                    var tr = visibleTrs[trNumber];
                    var cell = $(tr).children('td, th')[tdNumber];
                    responseDeferred.resolve({ editorContent: $(cell).html() });
                }
            }).fail(function (xhr, status, ex) {
                $(document).scrollTop(_scrollTop);
                _cleanResource();
                _currentCell.html(_currentCellContent);
                _currentCell.closest('table').find('td, th').removeClass('ite-editing-cell');
                _showing = false;
                messenger.fetchCommentContentError({ xhr: xhr });
                responseDeferred.reject('error fetching content');
            });
            return responseDeferred;
        };

        this.close = function (withSave, callback) {
            if (!_showing) {
                return;
            }

            if (withSave) {
                _btnSave.off('click');
                _btnSave.on('click', function (event) {
                    if (!_owner.checkDraft())
                        return;
                    _owner.saveCellClickHandler(this, event, callback);
                });
                _btnSave.click();
                return;
            }

            _deactivate();
            if (callback && typeof callback === 'function') {
                callback();
            }
        };

        var _deactivate = function () {
            AJS.Rte.Content.editorResetContentChanged();
            AJS.Confluence.QuickEdit.deactivateEditor();
            if (_currentCell) {
                _currentCell.closest('table').find('td, th').removeClass('ite-editing-cell');
            }
            _showing = false;
        };

        this.getContent = function () {
            return AJS.Rte.Content.getHtml();
        };

        this.isShowing = function () {
            return _showing;
        };

        var _preInitialise = function (options) {
            AJS.Confluence.QuickEdit.QuickComment.preInitialise(options);
            $(document).scrollTop($(document).scrollTop() - 250);
        };

        var _postInitialise = function (options) {
            AJS.Confluence.QuickEdit.QuickComment.postInitialise(options);
            var rteToolbar = $('#rte-toolbar');
            rteToolbar.on('mouseup', function (e) {
                e.stopPropagation();
            });
            var commentBody = options.$container.find('.quick-comment-body.comment-body');
            var $td = options.$container.closest('td, th');
            var fakeDiv = $('<div id="fakeDiv">');
            fakeDiv.html(AJS.Rte.Content.getHtml());
            $td.append(fakeDiv);
            $td.css('min-width', '100px');
            utils.setTdWidthAndUpdateTableFilterPanel($td, Math.min(window.initialCellWidth, fakeDiv.width()) + 18);
            options.editor.onKeyUp.add(_editorKeyUpListener);
            _updateToolbarTop();
            _saveEditedCell();
            _showing = true;
        };

        var _createCommenterFromComment = function () {
            return {
                userName: AJS.Meta.get('remote-user'), displayName: AJS.Meta.get('user-display-name'),
                profilePicture: { isDefault: true, path: AJS.Meta.get('current-user-avatar-url') }
            };
        };

        var _handleTransition = function ($comment) {
            var commenter = _createCommenterFromComment();
            var params = {
                'contentId': Confluence.getContentId(),
                'commenter': commenter,
                'context': {
                    'contextPath': AJS.Meta.get('context-path'),
                    'staticResourceUrlPrefix': AJS.Meta.get('static-resource-url-prefix')
                },
                'mode': 'edit'
            };

            var template = $(Confluence.Templates.Comments.displayEditEditorContainer(params));
            template.find('.comment-user-logo').remove();
            var $loadingContainer = $('.quick-comment-loading-container', template);
            $comment.hide();
            $comment.after(template);
            $loadingContainer.fadeIn().spin('medium');
            _scrollTop = $(document).scrollTop();
            $loadingContainer[0].scrollIntoView();
        };

        var _cleanResource = function () {
            var $commentEditing = $('.comment.edit');
            $commentEditing.prev('.comment').show();
            $commentEditing.remove();
        };

        var _updateToolbarTop = function () {
            var currentOffset = window.mainHeader.offset();
            currentOffset.top += 41;
            window.toolbar.offset(currentOffset);
        };

        var _editorKeyUpListener = function (ed, evt) {
            var fakeDiv = $('#fakeDiv');
            fakeDiv.html(AJS.Rte.Content.getHtml());
            var $td = fakeDiv.closest('td, th');
            utils.setTdWidthAndUpdateTableFilterPanel($td, fakeDiv.width() + 18);
        };

        var _saveEditedCell = function () {
            $($('#wysiwygTextarea_ifr')[0].contentWindow.document).keydown(function (event) {
                if ((event.ctrlKey || event.metaKey) && String.fromCharCode(event.which).toLowerCase() == 's') {
                    event.preventDefault();
                    _owner.saveCellClickHandler(_btnSave[0], event);
                }
            });
        };

        var _addCellApproveCancelButtons = function (element) {
            _editActions = $(ACTONIC.INLINETABLEEDIT.ACTIONS.editActions());
            _btnSave = _editActions.find('#inline-editing-save-edit-cell');
            _btnCancel = _editActions.find('#inline-editing-cancel-changes-cell');
            element.append(_editActions);

            _btnSave.off('click');
            _btnSave.on('click', function (event) {
                if (!_owner.checkDraft())
                    return;
                _owner.saveCellClickHandler(this, event);

                // function sendToAmplitude put to window object when we initialize amplitude on front
                // (in cases when amplitude tracking is checked in the ITE configuration)
                if (window.sendToAmplitude) {
                    sendToAmplitude('overlaySave');
                }
            });

            _btnCancel.off('click');
            _btnCancel.on('click', function () {
                _owner.cancelCellEditClickHandler(this, event);
            });
        };
    }

    return new Editor();
});