/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.upgrade.v1;

import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import de.actonic.confluence.ctipe.component.AppSettingsManager;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsUpgrade001
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(SettingsUpgrade001.class);
    private final AppSettingsManager appSettingsManager;

    public SettingsUpgrade001(AppSettingsManager appSettingsManager) {
        this.appSettingsManager = appSettingsManager;
    }

    public int getBuildNumber() {
        return 1;
    }

    @Nonnull
    public String getShortDescription() {
        return "Upgrades ITE settings to new format";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        log.debug("Start upgrading...");
        String selectedSpaces = this.appSettingsManager.getSelectedSpaces();
        log.debug("Current list of selected spaces = '" + selectedSpaces + "'");
        String enabledFor = StringUtils.isNotBlank((String)selectedSpaces) ? "selectedSpaces" : "allSpaces";
        log.debug("will be set enabledFor = " + enabledFor);
        log.debug("saving...");
        this.appSettingsManager.setEnabledFor(enabledFor);
        log.debug("Done.");
        return Collections.emptySet();
    }

    @Nonnull
    public String getPluginKey() {
        return "de.actonic.inline-table-editing";
    }
}

