/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.component;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.opensymphony.module.propertyset.PropertySet;
import de.actonic.confluence.ctipe.component.AppSettingsManager;
import de.actonic.confluence.ctipe.model.UserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomUserSettingsService {
    private static final Logger log = LoggerFactory.getLogger(CustomUserSettingsService.class);
    @ComponentImport
    private UserSettingsService userSettingsService;
    @ComponentImport
    private UserAccessor userAccessor;
    private AppSettingsManager appSettingsManager;
    private final String PROPERTY_ON_EACH_PAGE = "ite-user-settings-on-each-page";
    private final String PROPERTY_BY_DOUBLE_CLICKING = "ite-user-settings-by-double-clicking";

    @Autowired
    public CustomUserSettingsService(UserSettingsService userSettingsService, UserAccessor userAccessor, AppSettingsManager appSettingsManager) {
        this.userSettingsService = userSettingsService;
        this.userAccessor = userAccessor;
        this.appSettingsManager = appSettingsManager;
    }

    public void setSettings(ConfluenceUser confluenceUser, UserSettings settings) {
        this.userSettingsService.updateUserSettings(confluenceUser.getKey(), userSettingsBuilder -> userSettingsBuilder.put("ite-user-settings-on-each-page", settings.isOnEachPage()).put("ite-user-settings-by-double-clicking", settings.isByDoubleClicking()).build());
        this.appSettingsManager.invalidateCache();
    }

    public UserSettings getSettings(ConfluenceUser confluenceUser) {
        UserSettings mySettings;
        com.atlassian.sal.api.usersettings.UserSettings userSettings = this.userSettingsService.getUserSettings(confluenceUser.getKey());
        if (userSettings.getKeys().isEmpty()) {
            mySettings = this.getOldSettings(confluenceUser);
            this.setSettings(confluenceUser, mySettings);
        } else {
            mySettings = UserSettings.builder().onEachPage((Boolean)userSettings.getBoolean("ite-user-settings-on-each-page").getOrElse((Object)true)).byDoubleClicking((Boolean)userSettings.getBoolean("ite-user-settings-by-double-clicking").getOrElse((Object)true)).selectedSpaces(this.appSettingsManager.getSelectedSpaces()).build();
        }
        return mySettings;
    }

    private UserSettings getOldSettings(ConfluenceUser confluenceUser) {
        UserSettings userSettings = new UserSettings();
        PropertySet propertySet = this.userAccessor.getPropertySet(confluenceUser);
        if (propertySet.exists("ite-user-settings-on-each-page")) {
            userSettings.setOnEachPage(propertySet.getBoolean("ite-user-settings-on-each-page"));
            userSettings.setByDoubleClicking(propertySet.getBoolean("ite-user-settings-by-double-clicking"));
            userSettings.setSelectedSpaces(this.appSettingsManager.getSelectedSpaces());
        } else {
            userSettings.setOnEachPage(true);
            userSettings.setByDoubleClicking(true);
            userSettings.setSelectedSpaces(this.appSettingsManager.getSelectedSpaces());
        }
        return userSettings;
    }
}

