require(["jquery", "ite/domReady", "ite/inline-editing/utils", "ite/core/table-compatibility", "ite/inline-editing/messenger", "ite/inline-editing/rest", "ite/inline-editing/cell-buttons", "ite/inline-editing/editor", "ite/user-profile-panel/rest", "ite/core/user-activity"],
    function ($, domReady, utils, tableCompatibility, messenger, rest, cellButtons, editor, userSettingsRest, UserActivity) {
        domReady(function () {
            if (utils.isItCurrentPageVersion() && utils.isStaticTablePresent()) {
                rest.loadSettings(function (settings) {
                    if (settings) {
                        window.inlineTableEditing = window.inlineTableEditing || {};
                        window.inlineTableEditing.alwaysShowIcons = settings.alwaysShowIcons;
                        window.inlineTableEditing.btnLayout = settings.btnLayout;
                        window.inlineTableEditing.byDoubleClicking = settings.byDoubleClicking;
                        if (settings.enableDraftChecking === "undefined") settings.enableDraftChecking = true;

                        const selectedSpaces = settings.selectedSpaces;
                        const selectedSpacesCollection = selectedSpaces?.toLowerCase().split(',');
                        const spaceKey = AJS.Meta.get('space-key').toLowerCase();
                        const isSpaceInScope = selectedSpacesCollection?.includes(spaceKey);

                        const spaceAllowedForIteMap = {
                            allSpaces: true,
                            selectedSpaces: isSpaceInScope,
                            exceptedSpaces: !isSpaceInScope,
                        };

                        if (settings.onEachPage && spaceAllowedForIteMap[settings.enabledFor]) {
                            new InlineTableEditing().init(settings);
                        }
                    }
                }, function () {
                    flags.simpleWarning("Failed to load Inline Table Editing plugin settings");
                });
            }
        });

        function InlineTableEditing() {
            var _this = this;
            var refToClickedCell;
            var refToHoveredCell;
            var refToEditCell;
            var prevContentTD;
            var lastDraftWhen = null;
            var isEditingMode = false;
            var checkingDraftIntervalRef;

            var ENDPOINT = {
                MOVE_ROW: 'move/row',
                MOVE_COLUMN: 'move/column',
                PAGE: 'page',
                BULK_UPDATE: 'bulkUpdate',
                MERGE: 'merge',
                SPLIT: 'split',
                PAINT: 'paint/cell',
            };

            this.init = function (settings) {
                //if (settings.enableDraftChecking === "undefined") settings.enableDraftChecking = true;
                if (utils.isItCurrentPageVersion()) {
                    setTimeout(function () {
                        if (utils.isStaticTablePresent()) {
                            _onMessenger();
                            editor.init(_this);
                            rest.getConfiguration(AJS.Meta.get('page-id'));
                            //_initFunctionsAndHandlers();
                        }
                    }, 1000);
                }

                if (settings.enableDraftChecking) {
                    UserActivity.init({
                        secondsBeforeIdle: 1*60, // 2 mins delay
                        onUserLeft: () => {
                            //console.log('onUserLeft');
                            if (checkingDraftIntervalRef) clearInterval(checkingDraftIntervalRef);
                        },
                        onUserReturnBack: () => {
                            //console.log('onUserReturnBack');
                            if (checkingDraftIntervalRef) clearInterval(checkingDraftIntervalRef);
                            checkingDraftIntervalRef = setInterval(function () {
                                _this.getDraftInfo();
                            }, 2*60*1000);
                        }
                    });
                    checkingDraftIntervalRef = setInterval(function () {
                        _this.getDraftInfo();
                    }, 2*60*1000);
                }

                $("body").append($(ACTONIC.INLINETABLEEDIT.ACTIONS.confirmSwitchToEditMode()));
            };

            var _onMessenger = function () {
                messenger.onRestActionStart(function () {
                    var $table = $('table');
                    $table.find('.mceSelected').removeClass('mceSelected');
                    utils.updateTableFilterPanel($table);
                });

                messenger.onRestActionSuccess(function (event, data) {
                    window.inlineTableEditing.pageVersion = data.pageVersion;
                });

                messenger.onRestActionError(function (event, data) {
                    if (data.endpoint != 'merge') {
                        if (data.xhr.status === 409) {
                            AJS.messages.error('#aui-flag-container', {
                                body: ACTONIC.INLINETABLEEDIT.CORE.getOperationError409({'operation': data.operation})
                            });
                        } else if (data.xhr.status === 401) {
                            _this.authorizedFalse();
                        } else {
                            AJS.messages.error('#aui-flag-container', {
                                body: ACTONIC.INLINETABLEEDIT.CORE.getOperationError({'operation': data.operation})
                            });
                        }
                        console.error('Inline Table Editing ' + data.operation + ' failed:');
                        console.error(JSON.stringify({data: data.dataToSend, response: data.xhr.responseText}));
                    }
                });

                messenger.onFetchCommentContentError(function (event, data) {
                    if (data.xhr.status === 404 && !data.xhr.responseJSON.authorized) {
                        _this.authorizedFalse();
                        cellButtons.enabled(true);
                    }
                });

                messenger.onRestGetConfigSuccess(function (event, data) {
                    _initFunctionsAndHandlers(data);
                });

                messenger.onRestGetConfigError(function (event, data) {
                    //console.log('event', event);
                    //console.log('data', data);
                    if (data.xhr.status === 403) {
                        AJS.messages.warning('#aui-flag-container', {
                            body: ACTONIC.INLINETABLEEDIT.CORE.getInvalidLicense(),
                            fadeout: true
                        });
                    } else if (data.xhr.status === 401) {
                        _this.authorizedFalse();
                    }
                    $.each($('table'), function (index, el) {
                        _disableTableEditing(el, data.xhr.responseText);
                    });
                });

                messenger.onMovedColumn(function (event, data) {
                    _moveColumnHandler(data);
                });
            };

            var _initFunctionsAndHandlers = function (config) {
                window.inlineTableEditing.pageVersion = AJS.Meta.get("page-version");//config.pageVersion;
                window.uuid = utils.uuidv4();


                var tablesToInitInlineEditing = tableCompatibility.getTablesToInitInlineEditing();
                tablesToInitInlineEditing.each(function (tableIndex) {
                    $(this).attr('data-table-index', tableIndex);
                    $(this).find('tr').each(function (index) {
                        var $tr = $(this);
                        var $table = $tr.closest('table');
                        if (utils.checkTableWrap(this)) {
                            if (!$table.hasClass('custom-ite-table')) $table.addClass('custom-ite-table');
                            _this.initCells($tr, index);
                        }
                        if ($table.attr('data-table-index') == tableIndex) {
                            $tr.data('trNumber', utils.getTrNumber($tr));
                        }
                    });
                });

                cellButtons.init(_this);

                tablesToInitInlineEditing.find('tbody').sortable({
                    handle: '.ite-drag-and-drop-handle-row',
                    update: _this.sortableHandler
                });

                $('.custom-ite-table').on('mouseover', 'th, td', function (event) {
                    refToHoveredCell = $(this);
                    refToClickedCell = utils.getParentCell(refToHoveredCell);
                    cellButtons.show(this);
                });

                $('body').prepend(ACTONIC.INLINETABLEEDIT.CORE.getFlagContainer());
                $('body').append(ACTONIC.INLINETABLEEDIT.CORE.confirmRowDelete());
                $('body').append(ACTONIC.INLINETABLEEDIT.CORE.confirmColumnDelete());

                if (window.inlineTableEditing.byDoubleClicking) {
                    $('table.ite-real-table.ite-marked-table').on('dblclick', '.custom-row', function () {
                        if (!_this.checkDraft())
                            return;
                        _this.editCellClickHandler(this);
                    });
                }

                $(document).on('click', '#cancel-delete-row-button, #cancel-delete-column-button', function () {
                    _cancelDeleteHandler();
                });

                $(document).on('click', '#confirm-delete-row-button', function () {
                    _confirmDeleteRowHandler();
                });

                $(document).on('click', '#confirm-delete-column-button', function () {
                    _confirmDeleteColumnHandler();
                });

                $(document).on('click', 'table thead.tableFloatingHeaderOriginal th, table thead tr.tablesorter-headerRow th', function () {
                    if (!$(this).parents('div.conf-macro[data-hasbody=false]').length) {
                        _disableTableEditing(this, AJS.I18n.getText('ite.disabled.has-been-sorted'));
                    }
                });
            };

            var _editCellInitEditor = function (event) {
                var $td = utils.getClickedCell(refToHoveredCell, event);
                refToEditCell = refToHoveredCell;
                cellButtons.enabled(false);
                editor.show($td);
            };

            this.savePrevContentTD = function ($td) {
                prevContentTD = $td.children();
                $('body').append(prevContentTD);
            };

            var _setCellHtml = function ($td) {
                var deferred = editor.fetchCommentContent($td, 'view');
                deferred.done(function (value) {
                    content = value.editorContent;

                    $td.html(content);
                    prevMarkers = prevContentTD.find('.inline-comment-marker');
                    prevMarkers.each(function () {
                        var prevMarker = $(this);
                        var dataRef = prevMarker.attr('data-ref');
                        var nextMarker = $td.find('.inline-comment-marker[data-ref=' + dataRef + ']');
                        if (nextMarker) {
                            nextMarker.replaceWith(prevMarker);
                            prevMarker.html(nextMarker.html());
                        }
                    });

                    var tr = $td.closest('tr');
                    _this.initCells(tr, tr.attr('ite-row-number'));
                });
                editor.close();
                cellButtons.enabled(true);
            };

            this.authorizedFalse = function () {
                AJS.messages.error('#aui-flag-container', {
                    body: ACTONIC.INLINETABLEEDIT.CORE.getOperationError401()
                });
            };

            var _updateRowNumbers = function (closestTr, addedOrRemovedTrNumber, numberUpdateFunction) {
                closestTr.closest('table').children('tbody').children('tr').each(function () {
                    var $tr = $(this);
                    var currentTrNumber = $tr.data('trNumber');
                    if (currentTrNumber >= addedOrRemovedTrNumber) {
                        $tr.data('trNumber', numberUpdateFunction(currentTrNumber));
                    }
                });
            };

            var _save = function (dataToSend, objectType, td, successCallback) {
                if (td !== undefined) {
                    td.html(ACTONIC.INLINETABLEEDIT.CORE.getSpinner());
                }
                rest.action(dataToSend, ENDPOINT.PAGE, 'POST', objectType + ' saving', function () {
                    if (td !== undefined) {
                        _setCellHtml(td);
                        utils.updateTableFilterPanel(td.closest('table'));
                        $(td).trigger('DOMCharacterDataModified');
                    }
                    messenger.tableChanged([$(refToHoveredCell).closest('table')]);
                    if (typeof successCallback === 'function') successCallback();
                });
            };

            var _saveColspanChange = function (endpoint, operation, $cell) {
                var maxColspan = 0;
                var update;
                $.each(window.updates, function (index, value) {
                    var colspan = value.colspan;
                    if (colspan > maxColspan) {
                        maxColspan = colspan;
                        update = value;
                    }
                });

                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    uuidv4: window.uuid,
                    tableNumber: update.tableNumber,
                    trNumber: update.trNumber,
                    tdNumber: update.tdNumber,
                    colspan: update.colspan
                };
                rest.action(dataToSend, endpoint, 'POST', operation, function () {
                    messenger.tableChanged([$(refToHoveredCell).closest('table')]);
                });
                var tr = $cell.closest('tr');
                _this.initCells(tr, tr.attr('ite-row-number'));
            };

            this.initCells = function ($tr, trIndex) {
                var tds = $tr.find('td, th');
                tds.each(function (tdIndex) {
                    _initCell($(this), trIndex, tdIndex);
                });
            };

            var _initCell = function ($td, trIndex, tdIndex) {
                $td.attr('data-row-index', trIndex);
                $td.attr('data-column-index', tdIndex + $td.closest('table').attr('data-table-index') * 100);
                $td.closest('tr').find('td, th').addClass('custom-row');
            };

            var _disableTableEditing = function (el, title) {
                var closestTable = $(el).closest('table');
                if (!$(closestTable).hasClass('ite-disable-editing-functions')) {
                    $(closestTable).addClass('ite-disable-editing-functions');
                    //$(closestTable).closest('.table-wrap').append(ACTONIC.INLINETABLEEDIT.CORE.inlineEditingDisabled({title: title})); // PSUP-587, ITE-39
                    $(closestTable).find('.ite-drag-and-drop-handle').remove();
                }
            };

            this.sortableHandler = function (event, ui) {
                if (!_this.checkDraft())
                    return;

                var $tr = ui.item;
                var table = $tr.closest('table');
                if (!table.find('.tablesorter-headerDesc, .tablesorter-headerAsc').length) {
                    var oldTrNumber = $tr.data('trNumber');
                    $tr.closest('tbody').find('tr').each(function () {
                        var $tr = $(this);
                        $tr.data('trNumber', utils.getTrNumber($tr));
                    });
                    var newTrNumber = $tr.data('trNumber');
                    var dataToSend = {
                        pageId: AJS.Meta.get('page-id'),
                        pageVersion: window.inlineTableEditing.pageVersion,
                        tableNumber: utils.getTableNumber($tr),
                        fromTrNumber: oldTrNumber,
                        toTrNumber: newTrNumber,
                        uuidv4: window.uuid
                    };
                    rest.action(dataToSend, ENDPOINT.MOVE_ROW, 'PUT', 'Row moving', function () {
                        messenger.tableChanged([$(refToHoveredCell).closest('table')]);
                    });
                }
            };

            var _moveColumnHandler = function (data) {
                if (!_this.checkDraft())
                    return;

                if (!data.table.find('.tablesorter-headerDesc,.tablesorter-headerAsc').length) {
                    var dataToSend = {
                        pageId: AJS.Meta.get('page-id'),
                        pageVersion: window.inlineTableEditing.pageVersion,
                        fromColumnNumber: data.from - 1,
                        toColumnNumber: data.to - 1,
                        tableNumber: utils.getTableNumber(data.thtb.find('> tr').first()),
                        uuidv4: window.uuid
                    };
                    rest.action(dataToSend, ENDPOINT.MOVE_COLUMN, 'PUT', 'Column moving', function () {
                        messenger.tableChanged([data.table]);
                    });
                }
            };

            var _cancelDeleteHandler = function () {
                AJS.dialog2('#static-dialog').hide();
                AJS.dialog2('#delete-column-static-dialog').hide();
            };

            var _confirmDeleteRowHandler = function () {
                AJS.dialog2('#static-dialog').hide();
                var closestTr = window.deletingRow;
                var deletedTrNumber = closestTr.data('trNumber');
                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    tableNumber: utils.getTableNumber(closestTr),
                    trNumber: deletedTrNumber,
                    uuidv4: window.uuid
                };
                rest.action(dataToSend, ENDPOINT.PAGE, 'DELETE', 'Row removing');
                _updateRowNumbers(closestTr, deletedTrNumber, utils.decrease);
                var closestTable = $(closestTr).closest('table');
                closestTr.remove();

                $(closestTable).trigger('DOMCharacterDataModified');
                messenger.tableChanged([closestTable]);
                cellButtons.enabled(true);
            };

            var _confirmDeleteColumnHandler = function () {
                AJS.dialog2('#delete-column-static-dialog').hide();
                var $cell = window.deletingCell;
                var $table = $cell.closest('table');
                $cell.addClass('mceSelected');
                window.each = tinymce.each;
                var TableGrid = require('ite/inline-editing/table-grid');
                TableGrid.init($cell.closest('table')[0], tinymce.DOM);
                window.updates = [];
                TableGrid.deleteCols();
                var dataToSend = {
                    updates: window.updates,
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    uuidv4: window.uuid
                };
                rest.action(dataToSend, ENDPOINT.BULK_UPDATE, 'POST', 'Column removing');
                $table.find('tr').each(function (index) {
                    _this.initCells($(this), index);
                });
                utils.updateTableFilterPanel($table);
                messenger.tableChanged([$table]);
            };

            this.saveCellClickHandler = function (refToClickedElement, event, successCallback) {
                var $td = utils.getClickedCell(refToClickedElement, event);
                var closestTr = $td.closest('tr');
                var newData = [];
                var newContent = editor.getContent();
                newData.push(newContent);
                closestTr.mouseleave();
                $td.css('min-width', '');
                _this.initCells(closestTr, closestTr.attr('ite-row-number'));
                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    tableNumber: utils.getTableNumber(closestTr),
                    trNumber: closestTr.attr('ite-row-number'),
                    tdNumber: $td.attr('ite-col-number'),
                    newData: newData,
                    newRow: false,
                    uuidv4: window.uuid
                };

                _save(dataToSend, 'Cell', $td, successCallback);
            };

            this.cancelCellEditClickHandler = function (refToClickedElement, event, newEdit) {
                var $td = utils.getClickedCell(refToClickedElement, event);
                var closestTr = $td.closest('tr');
                _setCellHtml($td);
                _initCell($td);
                $td.css('min-width', '');
                utils.setTdWidthAndUpdateTableFilterPanel($td, window.initialCellWidth);
                _this.initCells(closestTr, closestTr.attr('ite-row-number'));
                if (newEdit) {
                    _editCellInitEditor(event);
                }
            };

            this.deleteColumnHandler = function (event) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                window.deletingCell = $cell;
                var cloned = $cell.clone();
                var colspan = $cell.attr('colspan');
                if (colspan === undefined) {
                    colspan = 1;
                }
                var title = colspan == 1 ? 'Confirm the column deletion for cell' : ('Confirm ' + colspan + ' columns deletion for cell');
                $('#delete-column-static-dialog').find('.aui-dialog2-content').html(cloned[0].outerHTML);
                $('#delete-column-static-dialog').find('.aui-dialog2-header-main').text(title);
                $('#confirm-delete-column-button').text(colspan == 1 ? 'Delete the column' : ('Delete ' + colspan + ' columns'));
                AJS.dialog2('#delete-column-static-dialog').show();
            };

            this.splitCellHandler = function (event) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                $cell.addClass('mceSelected');
                window.each = tinymce.each;
                var TableGrid = require('ite/inline-editing/table-grid');
                TableGrid.init($cell.closest('table')[0], tinymce.DOM);
                window.updates = [];
                TableGrid.split();
                _saveColspanChange(ENDPOINT.SPLIT, 'Cell splitting', $cell);
            };

            this.clearCellHandler = function (event) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                var closestTr = $cell.closest('tr');
                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    tableNumber: utils.getTableNumber(closestTr),
                    trNumber: closestTr.attr('ite-row-number'),
                    tdNumber: $cell.attr('ite-col-number'),
                    newData: [''],
                    newRow: false,
                    uuidv4: window.uuid
                };
                _save(dataToSend, 'Cell', $cell);
            };

            this.mergeCellsHandler = function (event) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                $cell.addClass('mceSelected');
                $cell.next().addClass('mceSelected');
                window.each = tinymce.each;
                var TableGrid = require('ite/inline-editing/table-grid');
                TableGrid.init($cell.closest('table')[0], tinymce.DOM);
                window.updates = [];
                TableGrid.merge();
                _saveColspanChange(ENDPOINT.MERGE, 'Cells merging', $cell);
            };

            this.colorCellHandler = function (event, color) {
                var $td = utils.getClickedCell(refToClickedCell, event);
                var closestTr = $td.closest('tr');
                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    tableNumber: utils.getTableNumber(closestTr),
                    trNumber: closestTr.attr('ite-row-number'),
                    tdNumber: $td.attr('ite-col-number'),
                    tdColor: color,
                    uuidv4: window.uuid
                };
                rest.action(dataToSend, ENDPOINT.PAINT, 'POST', 'Paint cell', function () {
                    var prevColor = $td.attr('data-highlight-colour');
                    if (prevColor) {
                        $td.removeAttr('data-highlight-colour');
                        $td.removeClass('highlight-' + prevColor);
                    }
                    if (color) {
                        $td.attr('data-highlight-colour', color);
                        $td.addClass('highlight-' + color);
                    }
                });
            };

            this.insertColumnHandler = function (event, insertBefore) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                $cell.addClass('mceSelected');
                window.each = tinymce.each;
                var TableGrid = require('ite/inline-editing/table-grid');
                TableGrid.init($cell.closest('table')[0], tinymce.DOM);
                window.updates = [];
                var cells = TableGrid.insertCol(insertBefore);
                $.each(cells, function (index, value) {
                    var $td = $(value);
                    if (!$td.closest('thead').hasClass('tableFloatingHeader')) {
                        var $tr = $td.closest('tr');
                        value.classList.remove('mceSelected');
                        window.updates.push({
                            tableNumber: utils.getTableNumber($tr),
                            trNumber: $tr.data('trNumber'),
                            tdNumber: $td.parent().children().index($td),
                            newData: [value.outerHTML],
                            insertBefore: insertBefore
                        });
                        _this.initCells($tr, index);
                    }
                });
                var dataToSend = {
                    updates: window.updates,
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    uuidv4: window.uuid
                };
                rest.action(dataToSend, ENDPOINT.BULK_UPDATE, 'POST', 'Column inserting', function () {
                    $(refToHoveredCell).trigger('DOMCharacterDataModified');
                    messenger.tableChanged([$(refToHoveredCell).closest('table')]);
                });
            };

            this.editCellClickHandler = function (event) {
                cellButtons.beforeEdit();

                if (utils.isElementOfDisabledTable(event) || utils.isElementOfIncludedTable(event)) {
                    return;
                }

                if (editor.isShowing()) {
                    _this.cancelCellEditClickHandler(refToEditCell, event, true);
                    return;
                }

                _editCellInitEditor(event);
            };

            this.removeRowHandler = function (event) {
                var $cell = utils.getClickedCell(refToHoveredCell, event);
                var closestTr = $cell.closest('tr');
                window.deletingRow = closestTr;
                var cloned = closestTr.clone();
                $('#static-dialog').find('.aui-dialog2-content').html(cloned.html());
                AJS.dialog2('#static-dialog').show();
            };

            this.addRowBelowHandler = function (event) {
                var $cell = utils.getClickedCell(refToClickedCell, event);
                var closestTr = $cell.closest('tr');
                var $tr = $(ACTONIC.INLINETABLEEDIT.CORE.getNewRow({columns: new Array(closestTr.children('td,th').length)}));
                closestTr.after($tr);
                _saveNewRow($tr, closestTr.attr('ite-row-number'));
            };

            var _saveNewRow = function (closestTr, rowIndex) {
                var newData = [];
                closestTr.each(function () {
                    var tds = $(this).children('td, th');
                    tds.each(function () {
                        var $td = $(this);
                        var newContent = '<br>';
                        $td.html(newContent);
                        newData.push(this.outerHTML);
                    });
                    tds.each(function (index) {
                        _initCell($(this), rowIndex, index);
                    });
                });
                closestTr.removeClass('added');
                var addedTrNumber = utils.getTrNumber(closestTr);
                _updateRowNumbers(closestTr, addedTrNumber, utils.increase);
                closestTr.data('trNumber', addedTrNumber);
                var dataToSend = {
                    pageId: AJS.Meta.get('page-id'),
                    pageVersion: window.inlineTableEditing.pageVersion,
                    tableNumber: utils.getTableNumber(closestTr),
                    trNumber: addedTrNumber,
                    newData: newData,
                    newRow: true,
                    uuidv4: window.uuid
                };
                _save(dataToSend, 'Row');
                closestTr.trigger('chosen:updated');
            };

            this.checkDraft = function () {
                if (_this.isEditingMode) {
                    AJS.dialog2("#confirm-switch-to-edit-mode").show();
                    $("#confirm-switch-to-edit-mode-ok-btn").click(function () {
                        window.location = AJS.contextPath() + "/pages/editpage.action?pageId=" + AJS.params.pageId;
                    });
                    $("#confirm-switch-to-edit-mode-cancel-btn").click(function () {
                        AJS.dialog2("#confirm-switch-to-edit-mode").hide();
                    });
                    return false;
                }
                return true;
            };

            this.getDraftInfo = function () {
                $.ajax({
                    type: "GET",
                    url: AJS.contextPath() + "/rest/api/content/" + AJS.params.pageId + "?status=draft",
                    success: function (data) {
                        if (data) {
                            var when = data.version.when;
                            var displayName = data.version.by.displayName;
                            if (_this.lastDraftWhen == null) {
                                _this.lastDraftWhen = when;
                            } else if (AJS.params.userDisplayName != displayName && _this.lastDraftWhen != when) {
                                _this.lastDraftWhen = when;
                                _this.isEditingMode = true;
                            }
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                        console.error(jqXHR);
                    }
                });
            };
        }

        return new InlineTableEditing();
    });

