/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.rest;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.ctipe.component.RestrictionService;
import de.actonic.confluence.ctipe.model.RestrictionModel;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/restrictions")
public class RestrictionRest {
    private final RestrictionService restrictionService;
    private final Cache<String, String> restrictionsCache;
    private final Gson gson = new Gson();

    @Autowired
    public RestrictionRest(RestrictionService restrictionService, @ComponentImport CacheManager cacheManager) {
        this.restrictionService = restrictionService;
        this.restrictionsCache = cacheManager.getCache("inline-table-editing-restrictions");
    }

    @GET
    @Path(value="/{spaceKey}/{pageId}")
    public Response getRestrictions(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="pageId") Long pageId) {
        try {
            String cacheKey = String.valueOf(pageId);
            if (this.restrictionsCache.containsKey((Object)cacheKey)) {
                return Response.ok((Object)this.restrictionsCache.get((Object)cacheKey)).build();
            }
            ArrayList data = Lists.newArrayList();
            if (pageId != null && pageId > 0L) {
                data.addAll(this.restrictionService.getRestrictions(pageId, true));
            }
            data.addAll(this.restrictionService.getRestrictions(spaceKey, true));
            String responseContent = this.gson.toJson(data);
            this.restrictionsCache.put((Object)cacheKey, (Object)responseContent);
            return Response.ok((Object)responseContent).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response addRestriction(RestrictionModel model) {
        Long pageId = model.getPageId();
        String spaceKey = model.getSpaceKey();
        String groups = model.getGroups();
        String users = model.getUsers();
        try {
            this.restrictionsCache.removeAll();
            RestrictionModel restrictionModel = pageId != null && pageId > 0L ? this.restrictionService.addRestriction(pageId, groups, users) : this.restrictionService.addRestriction(spaceKey, groups, users);
            return Response.ok(restrictionModel != null ? this.gson.toJson(restrictionModel) : null).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/{id}")
    public Response updateRestriction(@PathParam(value="id") Integer restrictionId, RestrictionModel model) {
        Long pageId = model.getPageId();
        String spaceKey = model.getSpaceKey();
        String groups = model.getGroups();
        String users = model.getUsers();
        try {
            this.restrictionsCache.removeAll();
            if (pageId != null && pageId > 0L) {
                this.restrictionService.updateRestriction(pageId, restrictionId, groups, users);
            } else {
                this.restrictionService.updateRestriction(spaceKey, restrictionId, groups, users);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/{spaceKey}/{pageId}/{restrictionId}")
    public Response removeRestriction(@PathParam(value="spaceKey") String spaceKey, @PathParam(value="pageId") Long pageId, @PathParam(value="restrictionId") Integer restrictionId) {
        try {
            this.restrictionsCache.removeAll();
            if (pageId != null && pageId > 0L) {
                this.restrictionService.removeRestriction(pageId, restrictionId);
            } else {
                this.restrictionService.removeRestriction(spaceKey, restrictionId);
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/page/{pageId}")
    public Response removeAllRestrictionsForPage(@PathParam(value="pageId") Long pageId) {
        try {
            this.restrictionsCache.removeAll();
            this.restrictionService.removeAll(pageId);
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="/space/{spaceKey}")
    public Response removeAllRestrictionsForSpace(@PathParam(value="spaceKey") String spaceKey) {
        try {
            this.restrictionsCache.removeAll();
            this.restrictionService.removeAll(spaceKey);
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }
}

