/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.component;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewTableService {
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final XhtmlContent xhtmlContent;

    @Autowired
    public NewTableService(PageManager pageManager, XhtmlContent xhtmlContent) {
        this.pageManager = pageManager;
        this.xhtmlContent = xhtmlContent;
    }

    public String saveNewTable(Long pageId, String macroId, String table) throws XhtmlException {
        Page page = this.pageManager.getPage(pageId.longValue());
        DefaultConversionContext pageContext = new DefaultConversionContext((RenderContext)page.toPageContext());
        String[] newMacroId = new String[]{macroId};
        String bodyAsString = this.xhtmlContent.updateMacroDefinitions(page.getBodyAsString(), (ConversionContext)pageContext, macroDefinition -> {
            String macroBody = macroDefinition.getStorageBodyText();
            String defMacroId = this.getMacroId(macroDefinition, macroBody);
            if (StringUtils.equalsIgnoreCase((String)defMacroId, (String)macroId)) {
                newMacroId[0] = this.getMacroId(macroDefinition, table);
                Streamable streamable = Streamables.from((String)table);
                macroDefinition.setBody((MacroBody)RichTextMacroBody.withStorage((Streamable)streamable));
            }
            return macroDefinition;
        });
        this.pageManager.saveNewVersion((ContentEntityObject)page, page1 -> page.setBodyAsString(bodyAsString), DefaultSaveContext.DEFAULT);
        return newMacroId[0];
    }

    public String getMacroId(MacroDefinition macroDefinition, String storage) {
        String hash = DigestUtils.sha512Hex((String)storage);
        String macroId = macroDefinition.getMacroIdentifier().orElse(MacroId.fromString((String)hash)).getId();
        return macroId;
    }
}

