define("inline-table/config", ["jquery", "ite/inline-editing/rest"], function ($, rest) {
    function Configuration() {
        this.init = function () {
            $("#save").on("click", function (event) {
                event.preventDefault();
                let enableDraftChecking = $('#enable-draft-checking').prop('checked');
                let enableErrorTracking = $('#enable-error-tracking').prop('checked');
                let btnLayout = $('#button-left').prop('checked') ? 'left' : 'right';
                let selectedSpaces = $("#space-picker").val();
                rest.saveConfiguration({
                    alwaysShowIcons: false,
                    btnLayout,
                    selectedSpaces,
                    enableDraftChecking,
                    enableErrorTracking
                });
            });

            $('#enabled-for-all-spaces').click(function () {
                $("#space-picker").val([]).trigger("change");
                $("#space-picker").prop('disabled', true);
            });
            $('#enabled-for-selected-spaces').click(function () {
                $("#space-picker").prop('disabled', false);
            });

            this.loadConfig();
        };

        this.loadConfig = function () {
            rest.loadSettings((data) => {
                //let configObj = JSON.parse(data);
                let configObj = data;
                //console.log('rest.loadConfiguration', configObj);

                if (configObj.btnLayout === 'left') $('#button-left').prop('checked', true);
                if (configObj.btnLayout === 'right') $('#button-right').prop('checked', true);

                $('#enable-draft-checking').prop('checked', configObj.enableDraftChecking);
                $('#enable-error-tracking').prop('checked', configObj.enableErrorTracking);

                if (configObj.selectedSpaces === "") {
                    this.initializeSpacePicker();
                    $("#space-picker").prop('disabled', true);
                } else {
                    $('#enabled-for-selected-spaces').prop('checked', true);
                    let initialValuesArr = configObj.selectedSpaces.split(',');
                    this.initializeSpacePicker(initialValuesArr);
                    $("#space-picker").prop('disabled', false);
                }
            });
        };

        this.initializeSpacePicker = function (initialSpaceKeys) {
            var parent = $("#space-picker").parent();
            $("#space-picker").remove();
            $("#s2id_space-picker").remove();
            $(parent).append("<input type=\"text\" class=\"select long-field\" id=\"space-picker\">");

            var initialValues = [];
            var initialNames = [];
            if (initialSpaceKeys) {
                initialSpaceKeys.forEach(function (userName) {
                    initialValues.push({id: userName, text: userName});
                    initialNames.push(userName);
                });
            }

            AJS.$("#space-picker").auiSelect2({
                placeholder: 'Select spaces',
                allowClear: true,
                //minimumInputLength: 2,
                multiple: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/ctiperestresource/1.0/picker/spaces",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.text + ' (' + el.id + ')'
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    //log.debug("initSelection currentUserName = " + JSON.stringify(currentUserName));
                    //log.debug("initSelection initialValues = " + JSON.stringify(initialValues));
                    if (initialSpaceKeys) {
                        callback(initialValues);
                    }
                }
            });

            if (initialSpaceKeys) {
                //log.debug("set initialNames = " + JSON.stringify(initialNames));
                $("#space-picker").val(initialNames).trigger("change");
            }

            /*$("#space-picker").off("change");
            $("#space-picker").on("change", function () {
                if (!ignoreChangeEvents) {
                    $("#page-picker").select2("enable");
                    $("#s2id_page-picker a.select2-choice").removeClass("disabled-picker");

                    $("#user-picker").select2("disable");
                    $("#s2id_user-picker a.select2-choice").addClass("disabled-picker");
                }
                filterAuditLogs(1);
            });*/
        }
    }

    return new Configuration();
});