define("ite/inline-editing/cell-buttons", ["jquery", "ite/inline-editing/utils", "ite/inline-editing/messenger"], function ($, utils, messenger) {

    function CellButtons() {
        var _this = this;
        var _init = false;
        var _owner;
        var _list;
        var _editCellBtn;
        var _dropdownMenuBtn;
        var _colorCellMenu;
        var _insertColumnBeforeBtn;
        var _insertColumnAfterBtn;
        var _deleteColumnBtn;
        var _insertRowBelowBtn;
        var _deleteRowBtn;
        var _mergeCellsBtn;
        var _splitCellsBtn;
        var _clearCellBtn;
        var _columnHandle;
        var _rowHandle;
        var _currentCell;
        var _currentTable;
        //let isDragTableInit = false;
        let cellActionsHovered = false;
        let mouseLeaveDebounceTimer;

        this.init = function (owner) {
            _owner = owner;

            _list = $(ACTONIC.INLINETABLEEDIT.ACTIONS.dropdownActions());

            _editCellBtn = _list.find('.inline-editing-edit-cell-btn');
            _dropdownMenuBtn = _list.find('.inline-editing-cell-dropdown-menu');
            _colorCellMenu = _list.find('#inline-editing-color-cell-menu');
            _insertColumnBeforeBtn = _list.find('.inline-editing-insert-column-before-btn');
            _insertColumnAfterBtn = _list.find('.inline-editing-insert-column-after-btn');
            _deleteColumnBtn = _list.find('.inline-editing-delete-column-btn');
            _insertRowBelowBtn = _list.find('.inline-editing-insert-row-below-btn');
            _deleteRowBtn = _list.find('.inline-editing-remove-row-btn');
            _mergeCellsBtn = _list.find('.inline-editing-merge-cells-btn');
            _splitCellsBtn = _list.find('.inline-editing-split-cells-btn');
            _clearCellBtn = _list.find('.inline-editing-clear-cell-btn');


            $('body').append(_list);

            //$(document).append('<div id="absolute-position" style="position:absolute"><button>test</button></div> ');
            //var t = $('<div id="absolute-position" style="position:absolute"><button>test</button></div> ');
            //$('body').append(t);

            //$('body').append('<aui-inline-dialog id="ite-drag-and-drop-column-handle" class="ite-drag-and-drop-handle-column" alignment="top center" responds-to="hover"><span class="aui-icon aui-icon-small aui-iconfont-swap ui-sortable-handle"></span></aui-inline-dialog>');
            //$('body').append('<aui-inline-dialog id="ite-drag-and-drop-row-handle" class="ite-drag-and-drop-handle-row" alignment="left top" responds-to="hover"><span class="aui-icon aui-icon-small aui-iconfont-swap ui-sortable-handle"></span></aui-inline-dialog>');

            _columnHandle = $(ACTONIC.INLINETABLEEDIT.CORE.getNewColumnHandle());
            _columnHandle.off('click dblclick');
            _columnHandle.on('click dblclick', function (e) {
                e.stopPropagation();
            });

            _rowHandle = $(ACTONIC.INLINETABLEEDIT.CORE.getNewRowHandle(/*{direction: window.btnLayout}*/));

            $('#ite-action-dropdown-list').on('mouseleave', function (event) {
                cellActionsHovered = false;
                //console.log('#ite-action-dropdown-list mouseleave');
            });
            $('#ite-action-dropdown-list').on('mouseover', function (event) {
                cellActionsHovered = true;
                //console.log('#ite-action-dropdown-list mouseover');
            });

            $('.custom-ite-table th, .custom-ite-table td').on('mouseover', function (event) {
                //console.log('some cell mouseover');
                if (mouseLeaveDebounceTimer) {
                    //console.log('clearTimeout');
                    clearTimeout(mouseLeaveDebounceTimer);
                }
            });

            $('.custom-ite-table th, .custom-ite-table td').on('mouseleave', function (event) {
                //console.log('some cell mouseleave');
                mouseLeaveDebounceTimer = setTimeout(() => {
                    //console.log('cellActionsHovered', cellActionsHovered);
                    if (!cellActionsHovered) {
                        _columnHandle.hide();
                        _rowHandle.hide();
                        _list.hide();
                    }
                }, 300);

                //_list.hide();
            });

            _off();
            _on();

            document.onselectionchange =  () => {
                this._repaintHandles();
            };

            _init = true;
        };

        this.absoluteCoordinates = function ($element) {
            var offset = $element.offset();
            var posY = offset.top - $(window).scrollTop();
            var posX = offset.left - $(window).scrollLeft();
            return {
                left: posX,
                right: posX + $element.innerWidth(),
                top: posY,
                bottom: posY + $element.innerHeight(),
            }
        };

        this.show = function (element) {
            if (!_init) {
                return;
            }

            if (_currentCell && _currentCell[0] === element) {
                return;
            }

            if (utils.isElementOfDisabledTable(element) || utils.isElementOfIncludedTable(element)) {
                return;
            }

            if ($(element).hasClass('ite-editing-cell')) {
                return;
            }

            if (_currentCell && !_list.find('#ite-action-dropdown-list-actions').attr('aria-hidden')) {
                //console.log('should not be triggered?');
                //_dropdownMenuBtn.click();
            }

            _currentCell = $(element);
            _currentTable = _currentCell.closest('table');


            let absoluteCoordinates = this.absoluteCoordinates(_currentCell);
            //console.log('absoluteCoordinates', this.absoluteCoordinates(_currentCell));
            let cellActionsWidth = $(_list).width();
            //console.log('cellActionsWidth', cellActionsWidth);
            //console.log('_list left', absoluteCoordinates.right - 34);
            //console.log('_list top', absoluteCoordinates.top);
            //$(_list).css('left', absoluteCoordinates.right - 34).css('top', absoluteCoordinates.top);

            let currentRow = _currentCell.closest('tr');
            let tableFirstRow = _currentTable.find('tr:first');
            //console.log('currentRow === tableFirstRow', $(currentRow).is(tableFirstRow) );
            let newActionButtonsTop = $(currentRow).is(tableFirstRow) ? absoluteCoordinates.top + 8 : absoluteCoordinates.top;
            let newActionButtonsLeft = currentRow.find('td:first, th:first').is(_currentCell) ? absoluteCoordinates.right - 26 : absoluteCoordinates.right - 34;
            $(_list).css('left', newActionButtonsLeft).css('top', newActionButtonsTop);

            if (_currentTable.hasClass('ite-disable-editing-functions')) {
                _this.beforeEdit();
                return;
            }

            _currentTable.removeClass('ite-always-show-buttons');
            if (window.inlineTableEditing.alwaysShowIcons) {
                _currentTable.addClass('ite-always-show-buttons');
            }

            this._repaintHandles();

            if (_currentCell.closest('tr').find('td, th').length > 1) {
                _deleteColumnBtn.removeAttr('disabled');
            } else {
                _deleteColumnBtn.attr('disabled', 'disabled');
            }

            if (_currentCell.attr('colspan') > 1) {
                _splitCellsBtn.removeAttr('disabled');
            } else {
                _splitCellsBtn.attr('disabled', 'disabled');
            }

            if (_currentCell.is(':last-child')) {
                _mergeCellsBtn.attr('disabled', 'disabled');
            } else {
                _mergeCellsBtn.removeAttr('disabled');
            }

            if (_currentCell.is('td')) {
                _deleteRowBtn.removeAttr('disabled');
            } else {
                _deleteRowBtn.attr('disabled', 'disabled');
            }



            //_currentCell.append(_list); // TODO
            _list.show();
        };

        this.enabled = function (enabled) {
            if (enabled) {
                _init = true;
            } else {
                _init = false;
                _rowHandle.remove();
                _columnHandle.remove();
            }
        };

        this.beforeEdit = function () {
            $('body').append(_list);
            _list.hide();
        };

        var _on = function () {
            _editCellBtn.on('click dblclick', function (event) {
                if (!_owner.checkDraft())
                    return;
                _owner.editCellClickHandler(event);
            });
            _colorCellMenu.find('aui-item-link').on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.colorCellHandler(this, $(this).attr('data-color'));
            });
            _insertColumnBeforeBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.insertColumnHandler(this, true);
            });
            _deleteColumnBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _this.beforeEdit();
                _owner.deleteColumnHandler(this);
            });
            _insertColumnAfterBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.insertColumnHandler(this, false);
            });
            _mergeCellsBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.mergeCellsHandler(this);
            });
            _insertRowBelowBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.addRowBelowHandler(this);
            });
            _deleteRowBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _this.beforeEdit();
                _owner.removeRowHandler(this);
            });
            _splitCellsBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _owner.splitCellHandler(this);
            });
            _clearCellBtn.on('click', function () {
                if (!_owner.checkDraft())
                    return;
                _this.beforeEdit();
                _owner.clearCellHandler(this);
            });
        };

        var _off = function () {
            _editCellBtn.off('click dblclick');
            _colorCellMenu.find('aui-item-link').off('click');
            _insertColumnBeforeBtn.off('click');
            _deleteColumnBtn.off('click');
            _insertColumnAfterBtn.off('click');
            _mergeCellsBtn.off('click');
            _insertRowBelowBtn.off('click');
            _deleteRowBtn.off('click');
            _splitCellsBtn.off('click');
            _clearCellBtn.off('click');
        };

        this._repaintHandles = function () {
            if (!(_currentCell && _currentCell.length > 0)) {
                return;
            }

            var td;
            if (window.inlineTableEditing.btnLayout == 'left') {
                td = utils.getFirstTD(_currentCell);
            } else {
                td = utils.getLastTD(_currentCell);
            }
            if (!_hasSelectedText(td)) {
                td.append(_rowHandle);
                _rowHandle.show();

                let rowHeaderCellCords = this.absoluteCoordinates(td);
                //console.log('rowHeaderCellCords', rowHeaderCellCords);
                $(_rowHandle).css('left', rowHeaderCellCords.left).css('top', rowHeaderCellCords.top).css('height', rowHeaderCellCords.bottom - rowHeaderCellCords.top);

                //$("[aria-controls='ite-drag-and-drop-row-handle']").removeAttr("aria-controls");
                //$(td).attr("data-aui-trigger", "").attr("aria-controls", "ite-drag-and-drop-row-handle");
            } else {
                _rowHandle.remove();
            }

            _stopDragColumns();
            if (_isMovable()) {
                var th = utils.getTH(_currentCell);
                //console.log('th', th);

                if (!_hasSelectedText(th)) {

                    th.append(_columnHandle);
                    _columnHandle.show();

                    let headerCellCords = this.absoluteCoordinates(th);
                    //console.log('headerCellCords', headerCellCords);
                    $(_columnHandle).css('left', headerCellCords.left).css('top', headerCellCords.top).css('width', headerCellCords.right - headerCellCords.left);

                    //$("[aria-controls='ite-drag-and-drop-column-handle']").removeAttr("aria-controls");
                    //$(th).attr("data-aui-trigger", "").attr("aria-controls", "ite-drag-and-drop-column-handle");
                } else {
                    _columnHandle.remove();
                }
                _initDragColumns();
            } else {
                _columnHandle.remove();
            }
        };

        var _isMovable = function () {
            var movable = true;
            _currentTable.children('tbody, thead').children('tr').children('td, th').each(function () {
                var $cell = $(this);
                var colspan = $cell.attr('colspan');
                if (colspan > 1) {
                    movable = false;
                }
            });
            return movable;
        };

        var _hasSelectedText = function (handleContainer) {
            var parentEl = null, sel;
            if (window.getSelection) {
                sel = window.getSelection();
                if (sel.rangeCount) {
                    parentEl = sel.getRangeAt(0).commonAncestorContainer;
                    if (parentEl.nodeType != 1) {
                        parentEl = parentEl.parentNode;
                    }
                }
            } else if ((sel = document.selection) && sel.type != "Control") {
                parentEl = sel.createRange().parentElement();
            }

            if ($(parentEl).length > 0) {
                return handleContainer.is($(parentEl))
                    || $.contains(handleContainer[0], parentEl)
                    || $.contains(parentEl, handleContainer[0]);
            }

            return false;
        };

        var _stopDragColumns = function () {
            if (_currentTable.dragtable('instance')) {
                _currentTable.dragtable('destroy');
            }
        };

        var _initDragColumns = function () {
            //if (!isDragTableInit) {
            //console.log('_initDragColumns');
            //console.log($('.ite-drag-and-drop-handle-column').length);
            _currentTable.dragtable({
                //dragHandle: '.ite-drag-and-drop-handle-column',
                dragHandle: '.ite-drag-and-drop-handle-column',
                persistState: function (table) {
                    table.el.find('tr').each(function (i) {
                        _owner.initCells($(this), i);
                    });
                }
            });
            //isDragTableInit = true;
            //}

        };
    }

    return new CellButtons();
});
