define("ite/core/table-compatibility", ["jquery"], function ($) {

    var ignoreTableWithParents = [
      'ul.dragtable-sortable.ui-sortable.ui-sortable-disabled.dragtable-disabled',
      '.ite-macro-container',
      '.ite-macro-container-inited'
    ];

    function TableCompatibility() {
        this.getTablesToInitInlineEditing = function () {
            //console.log("#main-content table.ite-marked-table.ite-real-table = " + $('#main-content table.ite-marked-table.ite-real-table').length);

            return $('#main-content table.ite-marked-table.ite-real-table').filter(function () {
                return $(this).parents(ignoreTableWithParents.join(', ')).length === 0;
            });
        };
        this.isItRealTable = function (that) {
            //console.log("itIsNotDynamicallyCreatedTable = " + itIsNotDynamicallyCreatedTable(that));
            //console.log("checkTableWrap = " + checkTableWrap(that));

            return itIsNotDynamicallyCreatedTable(that) && checkTableWrap(that);
        };
        this.checkAllowedTables = function (that) {
            //console.log("isWrapperMacroInWhitelist = " + isWrapperMacroInWhitelist(that));
            //console.log("itIsNotDynamicallyCreatedTable = " + itIsNotDynamicallyCreatedTable(that));
            //console.log("itIsNotCheckTableFilterAndCharts = " + itIsNotCheckTableFilterAndCharts(that));
            //console.log("itIsNotAdvancedTables = " + itIsNotAdvancedTables(that));
            //console.log("checkTableWrap = " + checkTableWrap(that));

            return isWrapperMacroInWhitelist(that) ||
                (itIsNotDynamicallyCreatedTable(that) && itIsNotCheckTableFilterAndCharts(that) && itIsNotAdvancedTables(that) && checkTableWrap(that));
        };

        function isWrapperMacroInWhitelist(currentTableElement) {
            var macros = ['column', 'excerpt', 'expand', 'info', 'note', 'details' /* page-properties*/,
                'panel', 'section', 'tip', 'warning', 'presentation-slide', 'presentation-slide-fragment'];
            // check macros
            var isWrapperMacroInWhitelist = false;
            macros.forEach(function (macroName) {
                if ($(currentTableElement).parents('div.conf-macro').attr('data-macro-name') == macroName) isWrapperMacroInWhitelist = true;
            });

            return isWrapperMacroInWhitelist;
        }

        function itIsNotDynamicallyCreatedTable(that) {
            return !$(that).parents('div.conf-macro[data-hasbody="false"]').length;
        }

        function itIsNotCheckTableFilterAndCharts(that) {
            var pluginClassNames = ["table-filter", "pivot-table", "table-chart", "table-excerpt", "table-excerpt-include", "table-joiner"];
            for (var i = 0; i < pluginClassNames.length; i++) {
                if ($(that).parents('div.conf-macro[data-macro-name="' + pluginClassNames[i] + '"]').length > 0) {
                    return false;
                }
            }
            return true;
        }

        function itIsNotAdvancedTables(that) {
            if ($(that).parents('.appfire-table-plus-parms').length > 0) {
                return false;
            }
            return true;
        }

        function checkTableWrap(that) {
            return $(that).parents('div.table-wrap').length > 0;
        }
    }

    return new TableCompatibility();
});
