define('ite/restrictions/model/restriction', ['jquery', 'ajs', 'backbone', 'underscore'],
    function ($, AJS, Backbone, _) {
        "use strict";

        var Restriction = Backbone.Model.extend({
            /*defaults: {
                id: -1,
                entityType: -1,
                restrictionType: -1,
                users: [],
                groups: []
            }*/

            // url : AJS.contextPath() + "/rest/ctiperestresource/1.0/restrictions",
            urlRoot: AJS.contextPath() + "/rest/ctiperestresource/1.0/restrictions",

            validate: function () {
                return this.get("users") && this.get("groups");
            },

            destroy: function (options) {
                var deleteUrl = AJS.contextPath() + "/rest/ctiperestresource/1.0/restrictions/" + AJS.Meta.get("space-key") + "/" + (AJS.Meta.get("page-id") || -1) + "/" + this.id;
                var opts = _.extend({url: deleteUrl}, options || {});
                return Backbone.Model.prototype.destroy.call(this, opts);
            }
        });

        return Restriction;
    }
)