define("ite/inline-editing/messenger", ["jquery"], function ($) {

    function Messenger() {
        var _this = this;
        var EVENT = {
            TABLE_CHANGED: 'ite.tableChanged',
            REST_ACTION_START: 'ite.restAction.start',
            REST_ACTION_SUCCESS: 'ite.restAction.success',
            REST_ACTION_ERROR: 'ite.restAction.error',
            REST_GET_CONFIG_SUCCESS: 'ite.restGetConfig.success',
            REST_GET_CONFIG_ERROR: 'ite.restGetConfig.error',
            MOVED_COLUMN: 'ite.dragAndDrop.moved.column',
            EDITOR_FETCH_COMMENT_CONTENT_ERROR: 'ite.editor.fetchCommentContent.error'
        };

        var _addListener = function (eventType, handler) {
            $(document).on(eventType, handler);
        };

        var _broadcast = function (eventType, extraParameters) {
            $(document).trigger(eventType, extraParameters);
        };

        // tableChanged
        this.onTableChanged = function(handler) {
            _addListener(EVENT.TABLE_CHANGED, handler);
        };

        this.tableChanged = function(extraParameters) {
            _broadcast(EVENT.TABLE_CHANGED, extraParameters);
        };

        // restAction
        this.onRestActionStart = function(handler) {
            _addListener(EVENT.REST_ACTION_START, handler);
        };

        this.restActionStart = function(extraParameters) {
            _broadcast(EVENT.REST_ACTION_START, extraParameters);
        };

        this.onRestActionSuccess = function(handler) {
            _addListener(EVENT.REST_ACTION_SUCCESS, handler);
        };

        this.restActionSuccess = function(extraParameters) {
            _broadcast(EVENT.REST_ACTION_SUCCESS, extraParameters);
        };

        this.onRestActionError = function(handler) {
            _addListener(EVENT.REST_ACTION_ERROR, handler);
        };

        this.restActionError = function(extraParameters) {
            _broadcast(EVENT.REST_ACTION_ERROR, extraParameters);
        };

        // restGetConfig
        this.onRestGetConfigSuccess = function(handler) {
            _addListener(EVENT.REST_GET_CONFIG_SUCCESS, handler);
        };

        this.restGetConfigSuccess = function(extraParameters) {
            _broadcast(EVENT.REST_GET_CONFIG_SUCCESS, extraParameters);
        };

        this.onRestGetConfigError = function(handler) {
            _addListener(EVENT.REST_GET_CONFIG_ERROR, handler);
        };

        this.restGetConfigError = function(extraParameters) {
            _broadcast(EVENT.REST_GET_CONFIG_ERROR, extraParameters);
        };

        // dragAndDrop
        this.onMovedColumn = function(handler) {
            _addListener(EVENT.MOVED_COLUMN, handler);
        };

        this.movedColumn = function(extraParameters) {
            _broadcast(EVENT.MOVED_COLUMN, extraParameters);
        };

        // editor
        this.onFetchCommentContentError = function(handler) {
            _addListener(EVENT.EDITOR_FETCH_COMMENT_CONTENT_ERROR, handler);
        };

        this.fetchCommentContentError = function(extraParameters) {
            _broadcast(EVENT.EDITOR_FETCH_COMMENT_CONTENT_ERROR, extraParameters);
        };
    }

    return new Messenger();
});