$(function () {
    //console.log('start watching');
    var tableCompatibility = require("ite/core/table-compatibility");
    var messenger = require("ite/inline-editing/messenger");

    messenger.onTableChanged(function (event, changedTable) {
        //console.log("ite.tableChanged event");
        //console.log(changedTable);
        setTableMarkup(changedTable);
    });

    if (isPageReadyToSearchForTables()) {
        //console.log("#main-content is here");
        if ($("#main-content table.confluenceTable").length) {
            $("#main-content table.confluenceTable").each(function (index, currentTable) {
                if (!$(currentTable).hasClass("ite-marked-table")) {
                    setTableMarkup(currentTable);
                }
            });
        } else {
            observeForNewTables();
        }
    } else {
        var firstCallInterval = setInterval(function () {
            if (isPageReadyToSearchForTables()) {
                clearInterval(firstCallInterval);

                observeForNewTables();
            }
        }, 1);
    }

    function observeForNewTables() {
        //console.log("watchForExistingTables");
        const targetNode = document.getElementById("main-content");
        const config = {childList: true, subtree: true};
        const callback = function (mutationsList, observer) {
            mutationsList.forEach(function(mutation) {
                //console.log("+++++++++++++ table.confluenceTable.length = " + $("#main-content table.confluenceTable").length);
                if ($("#main-content table.confluenceTable").length) {
                    $("#main-content table.confluenceTable").each(function (index, currentTable) {
                        if (!$(currentTable).hasClass("ite-marked-table")) {
                            setTableMarkup(currentTable);
                        }
                    });
                }
            });
        };
        const observer = new MutationObserver(callback);
        observer.observe(targetNode, config);

        setTimeout(function () {
            observer.disconnect()
        }, 2000);
    }

    function setTableMarkup(currentTable) {
        //console.log("setTableMarkup");
        //console.log(currentTable);
        //console.log("isTableAllowed = " + tableCompatibility.checkAllowedTables(currentTable));
        $(currentTable).addClass("ite-marked-table");
        var isItRealTable = tableCompatibility.isItRealTable(currentTable);
        if (isItRealTable) {
            $(currentTable).addClass("ite-real-table");
        } else {
            $(currentTable).addClass("ite-virtual-table");
        }
        //console.log("isItRealTable = " + tableCompatibility.isItRealTable(currentTable));
        $(currentTable).find("> thead.tableFloatingHeaderOriginal > tr, > tbody > tr, > thead:not([class]) > tr").each(function (rowIndex, currentTr) {
            //console.log("currentTable currentTr rowIndex = " + rowIndex);
            $(currentTr).attr("ite-row-number", rowIndex);
            $(currentTr).find("> th, > td").each(function (colIndex, currentTd) {
                $(currentTd).attr("ite-col-number", colIndex);
            });
        });
        if ($(currentTable).find("> tbody > tr:hidden").length) {
            $(currentTable).addClass("ite-disable-editing-functions");
        }
    }

    function isPageReadyToSearchForTables() {
        return $("#main-content").length > 0;
    }
});


