/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.rest;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.ctipe.component.SecurityCheckManager;
import de.actonic.confluence.ctipe.model.IdTextModel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/picker")
@Produces(value={"application/json"})
public class PickerRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final GroupManager groupManager;
    private final SecurityCheckManager securityCheckManager;

    @Autowired
    public PickerRest(UserAccessor userAccessor, SpaceManager spaceManager, PageManager pageManager, GroupManager groupManager, SecurityCheckManager securityCheckManager) {
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.groupManager = groupManager;
        this.securityCheckManager = securityCheckManager;
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getUsers(@QueryParam(value="q") String query) {
        Pager pager = this.userAccessor.getUsers();
        ArrayList users = Lists.newArrayList();
        while (!pager.onLastPage()) {
            users.addAll(pager.getCurrentPage());
        }
        if (pager.onLastPage()) {
            users.addAll(pager.getCurrentPage());
        }
        List idTextModels = users.stream().filter(user -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)user.getName(), (CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)user.getFullName(), (CharSequence)query)).limit(20L).map(user -> new IdTextModel(user.getName(), user.getFullName())).collect(Collectors.toList());
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getGroups(@QueryParam(value="query") String query, @QueryParam(value="maxResults") int maxResults) {
        try {
            Pager pager = this.groupManager.getGroups();
            ArrayList groups = Lists.newArrayList();
            while (!pager.onLastPage()) {
                groups.addAll(this.filterGroupsByPartOfName(pager.getCurrentPage(), query));
            }
            if (pager.onLastPage()) {
                groups.addAll(this.filterGroupsByPartOfName(pager.getCurrentPage(), query));
            }
            List idTextModels = groups.stream().map(group -> new IdTextModel(group.getName(), group.getName())).limit(maxResults).collect(Collectors.toList());
            Gson gson = new Gson();
            return Response.ok((Object)new Gson().toJson(gson.toJsonTree(idTextModels))).build();
        }
        catch (EntityException e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)new Gson().toJson(e.getMessage())).build();
        }
    }

    private List<Group> filterGroupsByPartOfName(List<Group> groups, String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return groups;
        }
        return groups.stream().filter(group -> StringUtils.containsIgnoreCase((CharSequence)group.getName(), (CharSequence)query)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/spaces")
    @Produces(value={"application/json"})
    @XsrfProtectionExcluded
    public Response getSpaces(@QueryParam(value="q") String query) {
        if (!this.securityCheckManager.isUserHasPermissions().booleanValue()) {
            return Response.status((int)403).entity((Object)"Access denied").build();
        }
        List spaces = this.spaceManager.getAllSpaces();
        List idTextModels = spaces.stream().filter(space -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)space.getName(), (CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)space.getKey(), (CharSequence)query)).limit(20L).map(space -> new IdTextModel(space.getKey(), space.getName())).collect(Collectors.toList());
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson(gson.toJsonTree(idTextModels))).build();
    }
}

