/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.component;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.PropertySet;
import de.actonic.confluence.ctipe.component.AppSettingsManager;
import de.actonic.confluence.ctipe.model.UserSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSettingsService {
    private static final Logger log = LoggerFactory.getLogger(UserSettingsService.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    private final AppSettingsManager appSettingsManager;
    private final String PROPERTY_ON_EACH_PAGE = "ite-user-settings-on-each-page";
    private final String PROPERTY_BY_DOUBLE_CLICKING = "ite-user-settings-by-double-clicking";

    @Autowired
    public UserSettingsService(UserAccessor userAccessor, AppSettingsManager appSettingsManager) {
        this.userAccessor = userAccessor;
        this.appSettingsManager = appSettingsManager;
    }

    public void setSettings(ConfluenceUser confluenceUser, UserSettings settings) {
        PropertySet propertySet = this.userAccessor.getPropertySet(confluenceUser);
        propertySet.setBoolean("ite-user-settings-on-each-page", settings.isOnEachPage());
        propertySet.setBoolean("ite-user-settings-by-double-clicking", settings.isByDoubleClicking());
    }

    public UserSettings getSettings(ConfluenceUser confluenceUser) {
        UserSettings userSettings = new UserSettings();
        PropertySet propertySet = this.userAccessor.getPropertySet(confluenceUser);
        if (propertySet.exists("ite-user-settings-on-each-page")) {
            userSettings.setOnEachPage(propertySet.getBoolean("ite-user-settings-on-each-page"));
            userSettings.setByDoubleClicking(propertySet.getBoolean("ite-user-settings-by-double-clicking"));
            userSettings.setSelectedSpaces(this.appSettingsManager.getSelectedSpaces());
        } else {
            userSettings.setOnEachPage(true);
            userSettings.setByDoubleClicking(true);
            userSettings.setSelectedSpaces(this.appSettingsManager.getSelectedSpaces());
        }
        return userSettings;
    }
}

