/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.ctipe.component;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotAllowedContentManager {
    static final Map<String, String> BLACK_LIST = ImmutableMap.builder().put((Object)"<ac:link>", (Object)"'Link' is not supported at the moment; ").put((Object)"<em>", (Object)"'italic' text style is not supported at the moment; ").put((Object)"<strong>", (Object)"'bold' style is not supported at the moment; ").put((Object)"<h1>", (Object)"'Header 1' is not supported at the moment; ").put((Object)"<h2>", (Object)"'Header 2' is not supported at the moment; ").put((Object)"<h3>", (Object)"'Header 3' is not supported at the moment; ").put((Object)"<h4>", (Object)"'Header 4' is not supported at the moment; ").put((Object)"<h5>", (Object)"'Header 5' is not supported at the moment; ").put((Object)"<ac:task-list>", (Object)"'task-list' is not supported at the moment; ").put((Object)"<ac:structured-macro", (Object)"'macro' is not supported at the moment; ").put((Object)"<td class=\"highlight-#", (Object)"'cell background' is not supported at the moment; ").build();

    @Autowired
    public NotAllowedContentManager() {
    }

    public Optional<String> isContentAllowed(String macroBody) {
        StringBuilder message = new StringBuilder();
        for (Map.Entry<String, String> blackListItem : BLACK_LIST.entrySet()) {
            if (!macroBody.contains(blackListItem.getKey())) continue;
            message.append(blackListItem.getValue());
        }
        if (Strings.isNullOrEmpty((String)message.toString())) {
            return Optional.empty();
        }
        return Optional.of(message.toString());
    }
}

