require(["jquery", "actonic-fus/core/log", "actonic-fus/core/flags", "actonic-fus/sudo-common", "actonic-fus/domReady"], function ($, log, flags, SudoCommon, domReady) {
    domReady(function () {
        new SudoHandlerForPageActions().init();
    });

    function SudoHandlerForPageActions() {
        this.init = function () {
            $(document).ready(function () {
                SudoCommon.checkGroup(function () {
                    flags.simpleWarning(AJS.I18n.getText("js.missed-group.error", AJS.contextPath() + "/admin/actonic/fus-configuration.action"))
                })
            })

            $("#sudo-start-session").on("click", function (e) {
                e.preventDefault();
                SudoCommon.showSudoDialog();
            });

            $("#unsudo-from-page-actions").on("click", function (e) {
                e.preventDefault();
                SudoCommon.unsudo();
            });
        }
    }

    return new SudoHandlerForPageActions();
});

