define("actonic-fus/sudo-common", ["jquery", "actonic-fus/core/log", "actonic-fus/core/flags", "actonic-fus/core/aui-select"], function ($, log, flags, AuiSelect) {
    function SudoDialog() {
        var _this = this;
        this.showSudoDialog = function () {
            isUserCanUseSudo(function (sudoInfo) {
                getRecentUsers(function (lastUsers) {
                    showDialog(lastUsers, sudoInfo);
                });
            });
        }

        function showDialog(lastUsers, sudoInfo) {
            $("#fus-dialog").remove();

            if (sudoInfo === "sudo-session") {
                $("#footer").append(Confluence.Sevya.Templates.Sudo.sudoDialog({
                    contextPath: AJS.contextPath(),
                    atlToken: AJS.Meta.get("atl-token"),
                    isSudoSession: true,
                    users: lastUsers
                }));

                AJS.dialog2("#fus-dialog").show();
            }

            if (sudoInfo === "true") {
                $("#footer").append(Confluence.Sevya.Templates.Sudo.sudoDialog({
                    contextPath: AJS.contextPath(),
                    atlToken: AJS.Meta.get("atl-token"),
                    isSudoSession: false,
                    users: lastUsers
                }));

                AJS.dialog2("#fus-dialog").on("show", function () {
                    AuiSelect.initUserPicker("#target-user-in-dialog");
                });

                AJS.dialog2("#fus-dialog").show();
            }

            initializeButtonHandlers();
            checkLicense();
        }

        function initializeButtonHandlers() {
            //log.debug("initializeButtonHandlers");
            $(".switch-to-user-btn").off("click");
            $(".switch-to-user-btn").on("click", function (e) {
                _this.sudo($(this).attr("data-user"));
            });

            $("#fus-dialog-form").off("submit");
            $("#fus-dialog-form").on("submit", function (e) {
                e.preventDefault();
                if ($("#target-user-in-dialog").val() !== "")
                    _this.sudo($("#target-user-in-dialog").val());
            });

            $("#unsudo-form").off("click");
            $("#unsudo-form").on("click", function () {
                _this.unsudo();
            });

            $("#fus-dialog .aui-close-button").off("click");
            $("#fus-dialog .aui-close-button").on("click", function () {
                AJS.dialog2("#fus-dialog").hide();
            });
        }

        this.sudo = function (targetUser) {
            $.ajax({
                url: AJS.contextPath() + "/rest/fus/1.0/sudo",
                type: "POST",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {
                    targetUser: targetUser
                }, success(data) {
                    flags.simpleSuccess("Successfully! The page will be reloaded in a second");
                    softReload();
                }, error(err) {
                    flags.simpleWarning(err.responseJSON.message);
                    softReload();
                }
            })
        }

        this.unsudo = function () {
            $.ajax({
                url: AJS.contextPath() + "/rest/fus/1.0/unsudo",
                type: "POST",
                headers: {"X-Atlassian-Token": "no-check"},
                success(data) {
                    flags.simpleSuccess("Successfully! The page will be reloaded in a second");
                    softReload();
                }, error(err) {
                    flags.simpleWarning(err.responseJSON.message);
                    softReload();
                }
            })
        }

        this.checkGroup = function (groupMissedCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/fus/1.0/check-group",
                type: "GET",
            }).done(function (data) {
                if (data === "missed") groupMissedCallback(data);
            })
        }

        function softReload() {
            setTimeout(function () {
                window.location.reload();
            }, 500);
        }

        function getRecentUsers(successCallback) {
            $.ajax({
                url: AJS.contextPath() + '/rest/fus/1.0/last-users',
                type: 'GET'
            }).done(function (data) {
                successCallback(data);
            });
        }

        function isUserCanUseSudo(successCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/fus/1.0/can-use?user=" + AJS.Meta.get("remote-user"),
                type: "GET",
                cache: false
            }).done(function (data) {
                successCallback(data);
            });
        }

        function checkLicense() {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/fus/1.0/license",
                success: function (licenseData) {
                    //log.debug("Rest.getLicense licenseData = " + JSON.stringify(licenseData));
                    if (licenseData && !licenseData.license) {
                        $("#license-not-valid-message").show();
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    log.error("Rest.getApplications errorMsg = " + JSON.stringify(jqXHR.responseText));
                }
            });
        }
    }

    return new SudoDialog();
});
