define("actonic-fus/settings/execute", ["jquery", "actonic-fus/settings/rest", "actonic-fus/core/flags", "actonic-fus/core/common"], function ($, Rest, Flag, Common) {

    function Execute() {
        var defaultFusValue = $("#sudo-user-group").val();
        var config;

        this.init = function () {
            Common.checkLicense();
            initializeFusGroupPicker($("#sudo-user-group"));

            $("#clean-group-picker-btn").click(function () {
                $("#sudo-user-group").val("").trigger("change");
            });

            $("#btn-save-sudo-group").click(function () {
                var sudoGroup = $("#sudo-user-group").val();
                request = {group: sudoGroup};

                Rest.setGroup(
                    request,
                    function(data) {
                        config = {
                            type: 'success',
                            title: AJS.I18n.getText("vm.configuration.message.success.title.fus-group"),
                            body: AJS.I18n.getText("vm.configuration.message.success.body.fus-group"),
                            close: 'auto'
                        };
                        Flag.show(config);
                    },
                    function (error) {
                        console.log(error);
                    }
                );
            });
        };

        function initializeFusGroupPicker(groupPickerSelector) {
            var defaultValue = groupPickerSelector.val();
            groupPickerSelector.auiSelect2({
                placeholder: AJS.I18n.getText("js.settings.group-picker.placeholder"),
                initSelection: function (element, callback) {
                    if (defaultFusValue) {
                        callback({id: defaultFusValue, text: defaultFusValue});
                    }
                },
                dropdownAutoWidth: true,
                allowClear: true,
                ajax: {
                    url: AJS.contextPath() + "/rest/fus/1.0/user-groups",
                    dataType: "json",
                    data: function (term) {
                        return {
                            q: term
                        };
                    },
                    results: function (data) {
                        return {
                            results: $.map(data, function (el) {
                                return {
                                    id: el.id,
                                    text: el.id
                                }
                            })
                        };
                    }
                },
                initSelection: function (element, callback) {
                    if (defaultValue) {
                        callback({id: defaultValue, text: defaultValue});
                    }
                }
            });
        }

    }

    return new Execute();
});