define("actonic-fus/core/common", ["jquery", "actonic-fus/core/flags"], function ($, Flag) {
    function Common() {
        this.checkLicense = function (config) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/fus/1.0/license",
                success: function (licenseData) {
                    //log.debug("Rest.getLicense licenseData = " + JSON.stringify(licenseData));
                    if (licenseData && !licenseData.license) {
                        var config = {
                            type: 'error',
                            title: AJS.I18n.getText("main.text.license-error"),
                            body: AJS.I18n.getText("main.text.license-error.message"),
                            close: 'manual'
                        };

                        Flag.show(config);
                        $("#license-not-valid-message").show();
                    }
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    log.error("Rest.getApplications errorMsg = " + JSON.stringify(jqXHR.responseText));
                }
            });
        }
    }

    return new Common();
});