define("actonic-fus/core/aui-select", ["jquery"], function ($) {
        function CoreAuiSelect() {
            this.initUserPicker = function (selector) {
                $(selector).auiSelect2({
                    placeholder: "Select user",
                    minimumInputLength: 2,
                    ajax: {
                        url: AJS.contextPath() + "/rest/fus/1.0/users/search",
                        dataType: "json",
                        quietMillis: 250,
                        data: function (term, page) {
                            return {
                                query: term,
                            };
                        },
                        results: function (data, page) {
                            return {
                                results: data.map(function (value) {
                                    return {
                                        id: value.name,
                                        text: value.displayName
                                    }
                                })
                            };
                        },
                        cache: true
                    },
                    formatResult: function (item) {
                        return item.text + ' (' + item.id + ')';
                    },
                    formatSelection: function (item) {
                        return item.text + ' (' + item.id + ')';
                    }
                });
            }
        }

        return new CoreAuiSelect();
    }
);
