/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.util;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import de.actonic.confluence.fus.component.manager.ConfigurationManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SudoAccessUtils {
    @ComponentImport
    private final UserManager userManager;
    private final ConfigurationManager configurationManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Autowired
    public SudoAccessUtils(UserManager userManager, ConfigurationManager configurationManager, UserAccessor userAccessor) {
        this.userManager = userManager;
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
    }

    public boolean canSudo(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        String runFusGroup = this.configurationManager.getFusGroup();
        if (StringUtils.isBlank((CharSequence)runFusGroup)) {
            return this.isAdministrator(user);
        }
        return this.isAdministrator(user) && this.isFusGroup(runFusGroup, user);
    }

    public boolean canConfigureSudo(ConfluenceUser user) {
        return this.isAdministrator(user);
    }

    public boolean isAdministrator(ConfluenceUser user) {
        return this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey());
    }

    public boolean isFusGroup(String fusGroup, ConfluenceUser user) {
        return this.userAccessor.hasMembership(fusGroup, user.getName());
    }
}

