/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.MultiTermBooleanQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.fus.component.LastUserKeyManager;
import de.actonic.confluence.fus.component.LicenseManager;
import de.actonic.confluence.fus.component.SudoService;
import de.actonic.confluence.fus.component.manager.ConfigurationManager;
import de.actonic.confluence.fus.exception.SudoForbiddenException;
import de.actonic.confluence.fus.model.UserModel;
import de.actonic.confluence.fus.model.json.IdTextModel;
import de.actonic.confluence.fus.util.SudoAccessUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json"})
public class SudoResources {
    private static final Logger log = LoggerFactory.getLogger(SudoResources.class);
    private final UserAccessor userAccessor;
    private final SudoAccessUtils sudoAccessUtils;
    private final LastUserKeyManager lastUserKeyManager;
    private final LicenseManager licenseManager;
    private final SudoService sudoService;
    private final ConfigurationManager configurationManager;
    private final Gson gson = new Gson();

    public SudoResources(@ComponentImport UserAccessor userAccessor, SudoAccessUtils sudoAccessUtils, LastUserKeyManager lastUserKeyManager, LicenseManager licenseManager, SudoService sudoService, ConfigurationManager configurationManager) {
        this.userAccessor = userAccessor;
        this.sudoAccessUtils = sudoAccessUtils;
        this.lastUserKeyManager = lastUserKeyManager;
        this.licenseManager = licenseManager;
        this.sudoService = sudoService;
        this.configurationManager = configurationManager;
    }

    @GET
    @Path(value="users/search")
    public List<UserModel> search(@QueryParam(value="query") String query) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList userModels = Lists.newArrayList();
        UserNameTermQuery userNameQuery = new UserNameTermQuery(query, "contains");
        FullNameTermQuery fullNameQuery = new FullNameTermQuery(query, "contains");
        try {
            List foundUsers = this.userAccessor.findUsersAsList(MultiTermBooleanQuery.anyOf((Query[])new Query[]{userNameQuery, fullNameQuery}));
            foundUsers.forEach(user -> {
                if (currentUser == null || !StringUtils.equals((CharSequence)user.getName(), (CharSequence)currentUser.getName())) {
                    userModels.add(UserModel.builder().name(user.getName()).displayName(user.getFullName()).build());
                }
            });
        }
        catch (EntityException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return userModels;
    }

    @GET
    @Path(value="can-use")
    @Produces(value={"text/plain"})
    public String canUseSudo(@QueryParam(value="user") String user, @Context HttpServletRequest request) {
        Object object;
        HttpSession session;
        if (request != null && (session = request.getSession()) != null && (object = session.getAttribute("sudo-session-id")) instanceof Integer && (Integer)object != 0) {
            return "sudo-session";
        }
        ConfluenceUser userObject = this.userAccessor.getUserByName(user);
        if (userObject == null || !this.sudoAccessUtils.canSudo(userObject)) {
            return Boolean.FALSE.toString();
        }
        return Boolean.TRUE.toString();
    }

    @GET
    @Path(value="last-users")
    public Response getLastUsers() {
        List<String> userKeys = this.lastUserKeyManager.pop(3);
        LinkedHashMap users = new LinkedHashMap();
        userKeys.forEach(u -> {
            if (u != null) {
                UserKey userKey = new UserKey(u);
                ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
                users.put(user.getName(), user.getFullName());
            }
        });
        return Response.ok((Object)this.gson.toJson(users)).build();
    }

    @POST
    @Path(value="switch")
    public Response switchTo(@FormParam(value="targetUser") String targetUser) {
        if (!this.licenseManager.isLicenseValid()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (this.sudoAccessUtils.canSudo(currentUser)) {
            this.sudoService.sudo(targetUser);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @Path(value="user-groups")
    @Produces(value={"application/json"})
    public Response getUserGroups(@QueryParam(value="q") String query) {
        try {
            List groupNamesForUserName = this.userAccessor.getGroupsAsList();
            List idTextModels = groupNamesForUserName.stream().filter(groupName -> StringUtils.isBlank((CharSequence)query) || StringUtils.containsIgnoreCase((CharSequence)groupName.getName(), (CharSequence)query)).map(groupName -> new IdTextModel(groupName.getName(), groupName.getName())).collect(Collectors.toList());
            return Response.ok((Object)this.gson.toJson(this.gson.toJsonTree(idTextModels))).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().entity((Object)this.gson.toJson((Object)e.getMessage())).build();
        }
    }

    @POST
    @Path(value="save-group")
    @Produces(value={"application/json"})
    public Response setGroup(@FormParam(value="group") String group) {
        this.configurationManager.setFusGroup(group);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="check-group")
    @Produces(value={"text/plain"})
    public Response checkGroup() {
        Group group;
        String fusGroup;
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.sudoAccessUtils.canConfigureSudo(user) && StringUtils.isNotBlank((CharSequence)(fusGroup = this.configurationManager.getFusGroup())) && (group = this.userAccessor.getGroup(fusGroup)) == null) {
            return Response.ok((Object)"missed", (String)"text/plain").build();
        }
        return Response.ok((Object)"ok", (String)"text/plain").build();
    }

    @POST
    @Path(value="/sudo")
    public Response doSudo(@FormParam(value="targetUser") String targetUser, @FormParam(value="pageId") Integer pageId) {
        try {
            return Response.ok().entity((Object)this.gson.toJson((Object)ImmutableMap.of((Object)"redirect", (Object)this.sudoService.doSudoAction(targetUser, pageId)))).build();
        }
        catch (SudoForbiddenException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.gson.toJson((Object)ImmutableMap.of((Object)"message", (Object)e.getMessage()))).build();
        }
    }

    @POST
    @Path(value="/unsudo")
    public Response unSudo(@FormParam(value="pageId") Integer pageId) {
        return Response.ok().entity((Object)this.gson.toJson((Object)ImmutableMap.of((Object)"redirect", (Object)this.sudoService.doUnSudoAction(pageId)))).build();
    }
}

