/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.component;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.seraph.ConfluenceUserPrincipal;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import de.actonic.confluence.fus.component.LastUserKeyManager;
import de.actonic.confluence.fus.component.SudoAuditManager;
import de.actonic.confluence.fus.exception.SudoForbiddenException;
import de.actonic.confluence.fus.util.SudoAccessUtils;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SudoService {
    public static final String SUDO_SESSION_ID_ATTRIBUTE = "sudo-session-id";
    private static final Logger logger = LoggerFactory.getLogger(SudoService.class);
    private static final String SUDO_SESSION_ORIGINAL_USER_ATTRIBUTE = "sudo-session-original-user";
    private final SudoAuditManager sudoSessionManager;
    private final SudoAccessUtils sudoAccessUtils;
    private final LastUserKeyManager lastUserKeyManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;
    private final SettingsManager settingsManager;
    private final I18nResolver i18n;

    @Autowired
    public SudoService(SudoAuditManager sudoSessionManager, SudoAccessUtils sudoAccessUtils, LastUserKeyManager lastUserKeyManager, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport SettingsManager settingsManager, @ComponentImport I18nResolver i18n) {
        this.sudoSessionManager = sudoSessionManager;
        this.sudoAccessUtils = sudoAccessUtils;
        this.lastUserKeyManager = lastUserKeyManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.settingsManager = settingsManager;
        this.i18n = i18n;
    }

    private HttpSession getSession() {
        return new StaticHttpContext().getRequest().getSession(true);
    }

    public void sudo(String targetUser) {
        if (this.isSudoSession()) {
            logger.warn("There isn't any active sudo session!");
            return;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.sudoAccessUtils.canSudo(currentUser)) {
            logger.warn("User {} doesn't have permissions to use sudo!", (Object)StringUtils.join((Object[])new String[]{currentUser.getFullName(), " (", currentUser.getName(), ")"}));
            return;
        }
        ConfluenceUser targetUserObject = this.userAccessor.getUserByName(targetUser);
        if (targetUserObject == null) {
            logger.warn("User with name {} doesn't exist or can't be a target for sudo!", (Object)targetUser);
            return;
        }
        Integer sudoSession = this.sudoSessionManager.openSession(currentUser.getName(), targetUserObject.getName());
        if (sudoSession == null) {
            logger.error("Can't create sudo session from user {} to user {}!", (Object)currentUser.getName(), (Object)targetUserObject.getName());
            return;
        }
        this.lastUserKeyManager.push(targetUserObject.getKey().getStringValue());
        HttpSession session = this.getSession();
        session.setAttribute(SUDO_SESSION_ID_ATTRIBUTE, (Object)sudoSession);
        session.setAttribute(SUDO_SESSION_ORIGINAL_USER_ATTRIBUTE, (Object)currentUser);
        ConfluenceUserPrincipal targetUserPrincipal = new ConfluenceUserPrincipal(targetUserObject);
        session.setAttribute("seraph_defaultauthenticator_user", (Object)targetUserPrincipal);
    }

    public void unSudo() {
        if (!this.isSudoSession()) {
            logger.warn("There isn't any active sudo session!");
            return;
        }
        HttpSession session = this.getSession();
        ConfluenceUser targetUser = AuthenticatedUserThreadLocal.get();
        ConfluenceUser originalUser = (ConfluenceUser)session.getAttribute(SUDO_SESSION_ORIGINAL_USER_ATTRIBUTE);
        session.removeAttribute(SUDO_SESSION_ID_ATTRIBUTE);
        session.removeAttribute(SUDO_SESSION_ORIGINAL_USER_ATTRIBUTE);
        ConfluenceUserPrincipal originalUserPrincipal = new ConfluenceUserPrincipal(originalUser);
        session.setAttribute("seraph_defaultauthenticator_user", (Object)originalUserPrincipal);
        this.sudoSessionManager.closeSession(originalUser.getName(), targetUser.getName());
    }

    public String doSudoAction(String targetUser, Integer pageId) throws SudoForbiddenException {
        String redirect = this.settingsManager.getGlobalSettings().getBaseUrl();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (this.sudoAccessUtils.canSudo(currentUser)) {
            Page page;
            this.sudo(targetUser);
            if (pageId != null && (page = this.pageManager.getPage((long)pageId.intValue())) != null) {
                redirect = page.getUrlPath();
            }
            return redirect;
        }
        throw new SudoForbiddenException(this.i18n.getText("sudo-access-denied-page.message"));
    }

    public String doUnSudoAction(Integer pageId) {
        Page page;
        String redirect = this.settingsManager.getGlobalSettings().getBaseUrl();
        if (this.isSudoSession()) {
            this.unSudo();
        }
        if (pageId != null && (page = this.pageManager.getPage((long)pageId.intValue())) != null) {
            redirect = page.getUrlPath();
        }
        return redirect;
    }

    public boolean isSudoSession() {
        Object object = this.getSession().getAttribute(SUDO_SESSION_ID_ATTRIBUTE);
        return object instanceof Integer && (Integer)object != 0;
    }
}

