/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.component;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SudoAuditManager {
    private static final String SUDO_CATEGORY_KEY = "de.actonic.confluence.fast-user-switcher";
    @ComponentImport
    private final AuditService auditService;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Autowired
    public SudoAuditManager(AuditService auditService, UserAccessor userAccessor) {
        this.auditService = auditService;
        this.userAccessor = userAccessor;
    }

    public Integer openSession(String currentUser, String targetUser) {
        ConfluenceUser currentConfUser = this.userAccessor.getUserByName(currentUser);
        ConfluenceUser targetConfUser = this.userAccessor.getUserByName(targetUser);
        ChangedValue changedValue = new ChangedValue.Builder(String.format("User switched from %s to %s", currentConfUser.getFullName(), targetConfUser.getFullName())).from(currentUser).to(targetUser).build();
        AuditEvent event = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)SUDO_CATEGORY_KEY, (String)"User switch").build()).affectedObject(AuditResource.builder((String)String.format("%s (%s)", targetConfUser.getFullName(), targetConfUser.getName()), (String)"user").build()).changedValue(changedValue).build();
        this.auditService.audit(event);
        return 1;
    }

    public void closeSession(String originalUser, String sudoedUser) {
        ConfluenceUser originalConfUser = this.userAccessor.getUserByName(originalUser);
        ConfluenceUser sudoedConfUser = this.userAccessor.getUserByName(sudoedUser);
        ChangedValue changedValue = new ChangedValue.Builder(String.format("User switched from %s to %s", sudoedConfUser.getFullName(), originalConfUser.getFullName())).from(sudoedUser).to(originalUser).build();
        AuditEvent event = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.USER_MANAGEMENT, (CoverageLevel)CoverageLevel.BASE, (String)SUDO_CATEGORY_KEY, (String)"User unswitch").build()).affectedObject(AuditResource.builder((String)String.format("%s (%s)", sudoedConfUser.getFullName(), sudoedConfUser.getName()), (String)"user").build()).changedValue(changedValue).build();
        this.auditService.audit(event);
    }
}

