/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.component;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LastUserKeyManager {
    private static final String BANDANA_LAST_USER_KEYS = "last-user-keys";
    @ComponentImport
    private final BandanaManager bandanaManager;
    private final ConfluenceBandanaContext BANDANA_CONTEXT = new ConfluenceBandanaContext("actonic-fus-last-user-keys-context");

    @Autowired
    public LastUserKeyManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    private List<String> get() {
        Gson gson = new Gson();
        Object obj = this.bandanaManager.getValue((BandanaContext)this.BANDANA_CONTEXT, BANDANA_LAST_USER_KEYS);
        if (obj == null) {
            return Lists.newArrayList();
        }
        return (List)gson.fromJson((String)obj, List.class);
    }

    private void set(List<String> userKeys) {
        Gson gson = new Gson();
        String userKeysJson = gson.toJson(userKeys);
        this.bandanaManager.setValue((BandanaContext)this.BANDANA_CONTEXT, BANDANA_LAST_USER_KEYS, (Object)userKeysJson);
    }

    public void push(String userKey) {
        if (StringUtils.isNotBlank((CharSequence)userKey)) {
            ArrayList newKeys = Lists.newArrayList();
            newKeys.add(userKey);
            newKeys.addAll(this.pop(9));
            this.set(newKeys);
        }
    }

    public List<String> pop(Integer size) {
        List<String> userKeys = this.get();
        if (userKeys.size() < size) {
            return userKeys;
        }
        return this.get().subList(0, size);
    }
}

