/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.fus.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.fus.action.AbstractSudoAction;
import de.actonic.confluence.fus.component.LastUserKeyManager;
import de.actonic.confluence.fus.component.SudoService;
import de.actonic.confluence.fus.util.SudoAccessUtils;
import java.util.LinkedHashMap;
import java.util.List;

public class SudoFormPageAction
extends AbstractSudoAction {
    private SudoService sudoService;
    private LastUserKeyManager lastUserKeyManager;
    @ComponentImport
    private UserAccessor userAccessor;
    private SudoAccessUtils sudoAccessUtils;

    public String execute() throws Exception {
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.sudoAccessUtils.canSudo(currentUser)) {
            List<String> userKeys = this.lastUserKeyManager.pop(10);
            LinkedHashMap users = new LinkedHashMap();
            userKeys.forEach(u -> {
                if (u != null) {
                    UserKey userKey = new UserKey(u);
                    ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
                    users.put(user.getName(), user.getFullName());
                }
            });
            this.data.put("isSudoSession", this.sudoService.isSudoSession());
            this.data.put("userKeys", users);
            return "success";
        }
        this.addActionError("sudo-access-denied-page.message", new Object[0]);
        return "securitybreach";
    }

    public void setSudoService(SudoService sudoService) {
        this.sudoService = sudoService;
    }

    public void setLastUserKeyManager(LastUserKeyManager lastUserKeyManager) {
        this.lastUserKeyManager = lastUserKeyManager;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setSudoAccessUtils(SudoAccessUtils sudoAccessUtils) {
        this.sudoAccessUtils = sudoAccessUtils;
    }
}

